/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.platform;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.sellcom.core.Contract;
import org.sellcom.core.io.Io;
import org.sellcom.core.util.platform.ExternalProcessException;

public class ExternalProcesses {
    private ExternalProcesses() {
    }

    public static void execute(String ... command) {
        Contract.checkArgument(command != null, "Command must not be null", new Object[0]);
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(command);
            int exitValue = process.waitFor();
            if (exitValue != 0) {
                throw new ExternalProcessException(String.format("Process terminated with exit value %d", exitValue));
            }
        }
        catch (InterruptedException e) {
            throw new ExternalProcessException("Process interrupted", e);
        }
        catch (IOException e) {
            throw new ExternalProcessException("Process failed", e);
        }
    }

    public static String executeAndReadOutput(String ... command) {
        Contract.checkArgument(command != null, "Command must not be null", new Object[0]);
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(command);
            String output = "";
            try (InputStream sourceStream = process.getInputStream();){
                output = Io.readString(sourceStream, StandardCharsets.UTF_8);
            }
            int exitValue = process.waitFor();
            if (exitValue != 0) {
                throw new ExternalProcessException(String.format("Process terminated with exit value %d", exitValue));
            }
            return output;
        }
        catch (InterruptedException e) {
            throw new ExternalProcessException("Process interrupted", e);
        }
        catch (IOException e) {
            throw new ExternalProcessException("Process failed", e);
        }
    }
}

