/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.platform;

import java.util.HashMap;
import java.util.Map;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;

public class ShutdownHooks {
    private static final Map<String, Thread> shutdownHooks = new HashMap<String, Thread>();

    private ShutdownHooks() {
    }

    public static void register(String name, Runnable runnable) {
        Contract.checkArgument(!Strings.isNullOrEmpty(name), "Name must not be null or empty", new Object[0]);
        Contract.checkArgument(runnable != null, "Runnable must not be null", new Object[0]);
        Runtime runtime = Runtime.getRuntime();
        if (shutdownHooks.containsKey(name)) {
            runtime.removeShutdownHook(shutdownHooks.remove(name));
        }
        Thread thread = new Thread(runnable);
        thread.setName(name);
        shutdownHooks.put(name, thread);
        runtime.addShutdownHook(thread);
    }

    public static void unregister(String name) {
        Contract.checkArgument(!Strings.isNullOrEmpty(name), "Name must not be null or empty", new Object[0]);
        if (shutdownHooks.containsKey(name)) {
            Runtime runtime = Runtime.getRuntime();
            runtime.removeShutdownHook(shutdownHooks.remove(name));
        }
    }
}

