/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.internal.math;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class RationalBigDecimal {
    public static final RationalBigDecimal ONE = RationalBigDecimal.of(BigDecimal.ONE);
    public static final RationalBigDecimal ZERO = RationalBigDecimal.of(BigDecimal.ZERO);
    private BigDecimal denominator;
    private BigDecimal numerator;

    private RationalBigDecimal(BigDecimal numerator, BigDecimal denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public RationalBigDecimal add(RationalBigDecimal other) {
        return this.denominator.equals(other.denominator) ? RationalBigDecimal.valueOf(this.numerator.add(other.numerator), this.denominator) : RationalBigDecimal.valueOf(this.numerator.multiply(other.denominator).add(other.numerator.multiply(this.denominator)), this.denominator.multiply(other.denominator));
    }

    public RationalBigDecimal multiply(RationalBigDecimal other) {
        return RationalBigDecimal.valueOf(this.numerator.multiply(other.numerator), this.denominator.multiply(other.denominator));
    }

    public static RationalBigDecimal of(BigDecimal value) {
        return new RationalBigDecimal(value, BigDecimal.ONE);
    }

    public BigDecimal toBigDecimal(int scale) {
        return this.numerator.divide(this.denominator, scale, RoundingMode.HALF_UP);
    }

    public static RationalBigDecimal valueOf(BigDecimal numerator, BigDecimal denominator) {
        return new RationalBigDecimal(numerator, denominator);
    }
}

