/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.io;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.HashMap;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;
import org.sellcom.core.io.MoreFiles;

public class ZipArchives {
    private static final Path ROOT_PATH = Paths.get("/", new String[0]);

    private ZipArchives() {
    }

    public static void createArchive(Path archive, Path sourceDirectory) throws IOException {
        ZipArchives.createArchive(archive, sourceDirectory, StandardCharsets.UTF_8);
    }

    public static void createArchive(Path archive, Path sourceDirectory, Charset charset) throws IOException {
        Contract.checkArgument(archive != null, "Archive must not be null", new Object[0]);
        Contract.checkArgument(sourceDirectory != null, "Source directory must not be null", new Object[0]);
        Contract.checkArgument(charset != null, "Charset must not be null", new Object[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("create", "true");
        parameters.put("encoding", charset.name());
        try (FileSystem archiveFileSystem = FileSystems.newFileSystem(ZipArchives.getFileSystemUri(archive), parameters, null);){
            Files.walkFileTree(sourceDirectory, new ContentsPackingVisitor(archiveFileSystem, sourceDirectory));
        }
    }

    public static void extractArchive(Path archive, Path destinationDirectory) throws IOException {
        ZipArchives.extractArchive(archive, destinationDirectory, StandardCharsets.UTF_8);
    }

    public static void extractArchive(Path archive, Path destinationDirectory, Charset charset) throws IOException {
        Contract.checkArgument(archive != null, "Archive must not be null", new Object[0]);
        Contract.checkArgument(destinationDirectory != null, "Destination directory must not be null", new Object[0]);
        Contract.checkArgument(charset != null, "Charset must not be null", new Object[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("create", "false");
        parameters.put("encoding", charset.name());
        try (FileSystem archiveFileSystem = FileSystems.newFileSystem(ZipArchives.getFileSystemUri(archive), parameters, null);){
            Files.walkFileTree(archiveFileSystem.getPath("/", new String[0]), new ContentsUnpackingVisitor(destinationDirectory));
        }
    }

    public static void walkArchiveTree(Path archive, FileVisitor<? super Path> visitor) throws IOException {
        ZipArchives.walkArchiveTree(archive, visitor, StandardCharsets.UTF_8);
    }

    public static void walkArchiveTree(Path archive, FileVisitor<? super Path> visitor, Charset charset) throws IOException {
        Contract.checkArgument(archive != null, "Archive must not be null", new Object[0]);
        Contract.checkArgument(visitor != null, "Visitor must not be null", new Object[0]);
        Contract.checkArgument(charset != null, "Charset must not be null", new Object[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("create", "false");
        parameters.put("encoding", charset.name());
        try (FileSystem archiveFileSystem = FileSystems.newFileSystem(ZipArchives.getFileSystemUri(archive), parameters, null);){
            Files.walkFileTree(archiveFileSystem.getPath("/", new String[0]), visitor);
        }
    }

    public static void walkArchiveTree(Path archive, int maxDepth, FileVisitor<? super Path> visitor) throws IOException {
        ZipArchives.walkArchiveTree(archive, maxDepth, visitor, StandardCharsets.UTF_8);
    }

    public static void walkArchiveTree(Path archive, int maxDepth, FileVisitor<? super Path> visitor, Charset charset) throws IOException {
        Contract.checkArgument(archive != null, "Archive must not be null", new Object[0]);
        Contract.checkArgument(maxDepth >= 0, "Maximum depth must not be negative", new Object[0]);
        Contract.checkArgument(visitor != null, "Visitor must not be null", new Object[0]);
        Contract.checkArgument(charset != null, "Charset must not be null", new Object[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("create", "false");
        parameters.put("encoding", charset.name());
        try (FileSystem archiveFileSystem = FileSystems.newFileSystem(ZipArchives.getFileSystemUri(archive), parameters, null);){
            Files.walkFileTree(archiveFileSystem.getPath("/", new String[0]), EnumSet.noneOf(FileVisitOption.class), maxDepth, visitor);
        }
    }

    private static URI getFileSystemUri(Path archive) throws IOException {
        try {
            URI archiveUri = archive.toUri();
            return new URI("jar:" + archiveUri.getScheme(), archiveUri.getPath(), null);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid file system", e);
        }
    }

    private static class ContentsUnpackingVisitor
    extends SimpleFileVisitor<Path> {
        private final Path destinationDirectory;

        private ContentsUnpackingVisitor(Path destinationDirectory) {
            this.destinationDirectory = destinationDirectory;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path packedDirectory, IOException exception) throws IOException {
            if (exception != null) {
                throw exception;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path packedDirectory, BasicFileAttributes attributes) throws IOException {
            if (!packedDirectory.equals(ROOT_PATH)) {
                String relativePath = packedDirectory.toString();
                relativePath = Strings.removePrefix(relativePath, "/");
                relativePath = Strings.removeSuffix(relativePath, "/");
                Path unpackedDirectory = this.destinationDirectory.resolve(relativePath);
                MoreFiles.ensureDirectory(unpackedDirectory);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path packedFile, BasicFileAttributes attributes) throws IOException {
            String relativePath = packedFile.toString();
            relativePath = Strings.removePrefix(relativePath, "/");
            relativePath = Strings.removeSuffix(relativePath, "/");
            Path unpackedFile = this.destinationDirectory.resolve(relativePath);
            Files.copy(packedFile, unpackedFile, StandardCopyOption.COPY_ATTRIBUTES);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path packedFile, IOException exception) throws IOException {
            if (exception != null) {
                throw exception;
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static class ContentsPackingVisitor
    extends SimpleFileVisitor<Path> {
        private final FileSystem archiveFileSystem;
        private final Path sourceDirectory;

        private ContentsPackingVisitor(FileSystem archiveFileSystem, Path sourceDirectory) {
            this.archiveFileSystem = archiveFileSystem;
            this.sourceDirectory = sourceDirectory;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path unpackedDirectory, IOException exception) throws IOException {
            if (exception != null) {
                throw exception;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path unpackedDirectory, BasicFileAttributes attributes) throws IOException {
            if (!unpackedDirectory.equals(this.sourceDirectory)) {
                String relativePath = this.sourceDirectory.relativize(unpackedDirectory).toString();
                Path packedDirectory = this.archiveFileSystem.getPath(relativePath, new String[0]);
                MoreFiles.ensureDirectory(packedDirectory);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path unpackedFile, BasicFileAttributes attributes) throws IOException {
            String relativePath = this.sourceDirectory.relativize(unpackedFile).toString();
            Path packedFile = this.archiveFileSystem.getPath(relativePath, new String[0]);
            Files.copy(unpackedFile, packedFile, StandardCopyOption.COPY_ATTRIBUTES);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path unpackedFile, IOException exception) throws IOException {
            if (exception != null) {
                throw exception;
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

