/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.io.encoding;

import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.sellcom.core.Contract;
import org.sellcom.core.util.MoreArrays;

public abstract class BinaryDecoder {
    public byte[] decode(byte[] input) {
        Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
        return this.decode(new String(input, StandardCharsets.US_ASCII));
    }

    public ByteBuffer decode(ByteBuffer input) {
        Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
        byte[] bytes = new byte[input.remaining()];
        input.get(bytes);
        return ByteBuffer.wrap(this.decode(bytes));
    }

    public abstract byte[] decode(String var1);

    public BigInteger decodeBigInteger(String input) {
        Contract.checkArgument(input != null, "Input must not be null", new Object[0]);
        return new BigInteger(MoreArrays.concat({0}, this.decode(input)));
    }

    public boolean supportsStreaming() {
        return false;
    }

    public InputStream wrap(InputStream stream) {
        throw new UnsupportedOperationException();
    }
}

