/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import org.sellcom.core.Contract;
import org.sellcom.core.math.MoreMath;

public class BigFraction
extends Number
implements Comparable<BigFraction> {
    public static final BigFraction ONE = BigFraction.valueOf(1L);
    public static final BigFraction ONE_HALF = BigFraction.valueOf(1L, 2L);
    public static final BigFraction ONE_QUARTER = BigFraction.valueOf(1L, 4L);
    public static final BigFraction ONE_THIRD = BigFraction.valueOf(1L, 3L);
    public static final BigFraction THREE_QUARTERS = BigFraction.valueOf(3L, 4L);
    public static final BigFraction TWO_THIRDS = BigFraction.valueOf(2L, 3L);
    public static final BigFraction ZERO = BigFraction.valueOf(0L);
    private static final long serialVersionUID = 8711587306362518263L;
    private BigInteger denominator;
    private BigInteger numerator;

    private BigFraction(BigInteger numerator, BigInteger denominator) {
        Contract.checkArgument(denominator.compareTo(BigInteger.ZERO) != 0, "Denominator must not be zero", new Object[0]);
        this.numerator = numerator;
        this.denominator = denominator;
        this.normalizeAndReduce();
    }

    public BigFraction abs() {
        return this.numerator.compareTo(BigInteger.ZERO) < 0 ? BigFraction.valueOf(MoreMath.absExact(this.numerator), this.denominator) : this;
    }

    public BigFraction add(BigFraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        if (other.equals(ZERO)) {
            return this;
        }
        if (this.denominator.compareTo(other.denominator) == 0) {
            return BigFraction.valueOf(this.numerator.add(other.numerator), this.denominator);
        }
        BigInteger commonDenominator = MoreMath.lcm(this.denominator, other.denominator);
        BigInteger numeratorCoefficient = commonDenominator.divide(this.denominator);
        BigInteger otherNumeratorCoefficient = commonDenominator.divide(other.denominator);
        return BigFraction.valueOf(numeratorCoefficient.multiply(this.numerator).add(otherNumeratorCoefficient.multiply(other.numerator)), commonDenominator);
    }

    public BigFraction add(BigInteger value) {
        Contract.checkArgument(value != null, "Value must not be null", new Object[0]);
        if (value.compareTo(BigInteger.ZERO) == 0) {
            return this;
        }
        return BigFraction.valueOf(this.numerator.add(value.multiply(this.denominator)), this.denominator);
    }

    public BigFraction add(long value) {
        if (value == 0L) {
            return this;
        }
        return BigFraction.valueOf(this.numerator.add(BigInteger.valueOf(value).multiply(this.denominator)), this.denominator);
    }

    @Override
    public int compareTo(BigFraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        BigInteger reductor = MoreMath.gcd(this.denominator, other.denominator);
        return this.numerator.multiply(other.denominator.divide(reductor)).compareTo(this.denominator.divide(reductor).multiply(other.numerator));
    }

    public BigFraction divide(BigFraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        Contract.check(!other.equals(ZERO), ArithmeticException.class, "Division by zero", new Object[0]);
        if (other.equals(ONE)) {
            return this;
        }
        return BigFraction.valueOf(this.numerator.multiply(other.denominator), this.denominator.multiply(other.numerator));
    }

    public BigFraction divide(BigInteger value) {
        Contract.checkArgument(value != null, "Value must not be null", new Object[0]);
        Contract.check(value.compareTo(BigInteger.ZERO) != 0, ArithmeticException.class, "Division by zero", new Object[0]);
        if (value.compareTo(BigInteger.ONE) == 0) {
            return this;
        }
        return BigFraction.valueOf(this.numerator, value.multiply(this.denominator));
    }

    public BigFraction divide(long value) {
        Contract.check(value != 0L, ArithmeticException.class, "Division by zero", new Object[0]);
        if (value == 1L) {
            return this;
        }
        return BigFraction.valueOf(this.numerator, BigInteger.valueOf(value).multiply(this.denominator));
    }

    @Override
    public double doubleValue() {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), MathContext.DECIMAL64).doubleValue();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof BigFraction) {
            BigFraction otherFraction = (BigFraction)other;
            return Objects.equals(this.numerator, otherFraction.numerator) && Objects.equals(this.denominator, otherFraction.denominator);
        }
        return false;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public BigInteger getDenominator() {
        return this.denominator;
    }

    public BigInteger getNumerator() {
        return this.numerator;
    }

    public int hashCode() {
        return Objects.hash(this.numerator, this.denominator);
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    public boolean isInteger() {
        return this.denominator == BigInteger.ZERO;
    }

    public int intValueExact() {
        return MoreMath.toIntExact(this.doubleValue());
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    public long longValueExact() {
        return MoreMath.toLongExact(this.doubleValue());
    }

    public BigFraction multiply(BigFraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        if (other.equals(ZERO)) {
            return ZERO;
        }
        if (other.equals(ONE)) {
            return this;
        }
        return BigFraction.valueOf(this.numerator.multiply(other.numerator), this.denominator.multiply(other.denominator));
    }

    public BigFraction multiply(BigInteger value) {
        Contract.checkArgument(value != null, "Value must not be null", new Object[0]);
        if (value.compareTo(BigInteger.ZERO) == 0) {
            return ZERO;
        }
        if (value.compareTo(BigInteger.ONE) == 0) {
            return this;
        }
        return BigFraction.valueOf(value.multiply(this.numerator), this.denominator);
    }

    public BigFraction multiply(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value == 1L) {
            return this;
        }
        return BigFraction.valueOf(BigInteger.valueOf(value).multiply(this.numerator), this.denominator);
    }

    public BigFraction negate() {
        return BigFraction.valueOf(this.numerator.negate(), this.denominator);
    }

    public static BigFraction parse(String text) {
        Contract.checkArgument(text != null, "Text must not be null", new Object[0]);
        int separatorIndex = text.indexOf(47);
        if (separatorIndex == -1) {
            throw new NumberFormatException("Invalid fraction: " + text);
        }
        try {
            BigInteger numerator = new BigInteger(text.substring(0, separatorIndex).trim());
            BigInteger denominator = new BigInteger(text.substring(separatorIndex + 1).trim());
            if (denominator.compareTo(BigInteger.ZERO) == 0) {
                throw new NumberFormatException("Invalid fraction: " + text);
            }
            return new BigFraction(numerator, denominator);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new NumberFormatException("Invalid fraction: " + text);
        }
    }

    public BigFraction pow(int exponent) {
        if ((long)exponent == 0L) {
            return ONE;
        }
        if ((long)exponent == 1L) {
            return this;
        }
        if ((long)exponent < 0L) {
            return BigFraction.valueOf(this.denominator.pow(-exponent), this.numerator.pow(-exponent));
        }
        return BigFraction.valueOf(this.numerator.pow(exponent), this.denominator.pow(exponent));
    }

    public BigFraction reciprocal() {
        Contract.check(this.numerator.compareTo(BigInteger.ZERO) != 0, ArithmeticException.class, "Division by zero", new Object[0]);
        return BigFraction.valueOf(this.denominator, this.numerator);
    }

    public long round(RoundingMode roundingMode) {
        Contract.checkArgument(roundingMode != null, "Rounding mode must not be null", new Object[0]);
        return this.toBigDecimal(0, roundingMode).longValueExact();
    }

    public int signum() {
        return this.numerator.signum();
    }

    public BigFraction subtract(BigFraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        if (other.equals(ZERO)) {
            return this;
        }
        if (this.denominator.compareTo(other.denominator) == 0) {
            return BigFraction.valueOf(this.numerator.subtract(other.numerator), this.denominator);
        }
        BigInteger commonDenominator = MoreMath.lcm(this.denominator, other.denominator);
        BigInteger numeratorCoefficient = commonDenominator.divide(this.denominator);
        BigInteger otherNumeratorCoefficient = commonDenominator.divide(other.denominator);
        return BigFraction.valueOf(numeratorCoefficient.multiply(this.numerator).subtract(otherNumeratorCoefficient.multiply(other.numerator)), commonDenominator);
    }

    public BigFraction subtract(BigInteger value) {
        Contract.checkArgument(value != null, "Value must not be null", new Object[0]);
        if (value.compareTo(BigInteger.ZERO) == 0) {
            return this;
        }
        return BigFraction.valueOf(this.numerator.subtract(value.multiply(this.denominator)), this.denominator);
    }

    public BigFraction subtract(long value) {
        if (value == 0L) {
            return this;
        }
        return BigFraction.valueOf(this.numerator.subtract(BigInteger.valueOf(value).multiply(this.denominator)), this.denominator);
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator));
    }

    public BigDecimal toBigDecimal(int scale, RoundingMode roundingMode) {
        Contract.checkArgument(roundingMode != null, "Rounding mode must not be null", new Object[0]);
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), scale, roundingMode);
    }

    public String toString() {
        return String.format("%d/%d", this.numerator, this.denominator);
    }

    public static BigFraction valueOf(BigInteger value) {
        Contract.checkArgument(value != null, "Value must not be null", new Object[0]);
        return new BigFraction(value, BigInteger.ONE);
    }

    public static BigFraction valueOf(BigInteger numerator, BigInteger denominator) {
        Contract.checkArgument(numerator != null, "Numerator must not be null", new Object[0]);
        Contract.checkArgument(denominator != null, "Denominator must not be null", new Object[0]);
        return new BigFraction(numerator, denominator);
    }

    public static BigFraction valueOf(long value) {
        return new BigFraction(BigInteger.valueOf(value), BigInteger.ONE);
    }

    public static BigFraction valueOf(long numerator, long denominator) {
        return new BigFraction(BigInteger.valueOf(numerator), BigInteger.valueOf(denominator));
    }

    private void normalizeAndReduce() {
        BigInteger reductor;
        if (this.numerator.compareTo(BigInteger.ZERO) == 0) {
            this.denominator = BigInteger.ONE;
            return;
        }
        if (this.denominator.compareTo(BigInteger.ZERO) < 0) {
            this.numerator = MoreMath.negateExact(this.numerator);
            this.denominator = MoreMath.negateExact(this.denominator);
        }
        if ((reductor = MoreMath.gcd(this.numerator, this.denominator)).compareTo(BigInteger.ONE) > 0) {
            this.numerator = this.numerator.divide(reductor);
            this.denominator = this.denominator.divide(reductor);
        }
    }
}

