/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.sellcom.core.Contract;
import org.sellcom.core.math.MoreMath;

public class LongFraction
extends Number
implements Comparable<LongFraction> {
    public static final LongFraction ONE = LongFraction.valueOf(1L);
    public static final LongFraction ONE_HALF = LongFraction.valueOf(1L, 2L);
    public static final LongFraction ONE_QUARTER = LongFraction.valueOf(1L, 4L);
    public static final LongFraction ONE_THIRD = LongFraction.valueOf(1L, 3L);
    public static final LongFraction THREE_QUARTERS = LongFraction.valueOf(3L, 4L);
    public static final LongFraction TWO_THIRDS = LongFraction.valueOf(2L, 3L);
    public static final LongFraction ZERO = LongFraction.valueOf(0L);
    private static final long serialVersionUID = 3883659606867197439L;
    private long denominator;
    private long numerator;

    private LongFraction(long numerator, long denominator) {
        Contract.checkArgument(denominator != 0L, "Denominator must not be zero", new Object[0]);
        this.numerator = numerator;
        this.denominator = denominator;
        this.normalizeAndReduce();
    }

    public LongFraction abs() {
        return this.numerator < 0L ? LongFraction.valueOf(MoreMath.absExact(this.numerator), this.denominator) : this;
    }

    public LongFraction add(long value) {
        if (value == 0L) {
            return this;
        }
        return LongFraction.valueOf(Math.addExact(this.numerator, Math.multiplyExact(value, this.denominator)), this.denominator);
    }

    public LongFraction add(LongFraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        if (other.equals(ZERO)) {
            return this;
        }
        if (this.denominator == other.denominator) {
            return LongFraction.valueOf(Math.addExact(this.numerator, other.numerator), this.denominator);
        }
        long commonDenominator = MoreMath.lcm(this.denominator, other.denominator);
        long numeratorCoefficient = commonDenominator / this.denominator;
        long otherNumeratorCoefficient = commonDenominator / other.denominator;
        return LongFraction.valueOf(Math.addExact(Math.multiplyExact(numeratorCoefficient, this.numerator), Math.multiplyExact(otherNumeratorCoefficient, other.numerator)), commonDenominator);
    }

    @Override
    public int compareTo(LongFraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        long reductor = MoreMath.gcd(this.denominator, other.denominator);
        return Long.compare(Math.multiplyExact(this.numerator, other.denominator / reductor), Math.multiplyExact(this.denominator / reductor, other.numerator));
    }

    public LongFraction divide(long value) {
        Contract.check(value != 0L, ArithmeticException.class, "Division by zero", new Object[0]);
        if (value == 1L) {
            return this;
        }
        return LongFraction.valueOf(this.numerator, Math.multiplyExact(value, this.denominator));
    }

    public LongFraction divide(LongFraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        Contract.check(!other.equals(ZERO), ArithmeticException.class, "Division by zero", new Object[0]);
        if (other.equals(ONE)) {
            return this;
        }
        return LongFraction.valueOf(Math.multiplyExact(this.numerator, other.denominator), Math.multiplyExact(this.denominator, other.numerator));
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof LongFraction) {
            LongFraction otherFraction = (LongFraction)other;
            return this.numerator == otherFraction.numerator && this.denominator == otherFraction.denominator;
        }
        return false;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public long getDenominator() {
        return this.denominator;
    }

    public long getNumerator() {
        return this.numerator;
    }

    public int hashCode() {
        return Objects.hash(this.numerator, this.denominator);
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    public boolean isInteger() {
        return this.denominator == 1L;
    }

    public int intValueExact() {
        return MoreMath.toIntExact(this.doubleValue());
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    public long longValueExact() {
        return MoreMath.toLongExact(this.doubleValue());
    }

    public LongFraction multiply(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value == 1L) {
            return this;
        }
        return LongFraction.valueOf(Math.multiplyExact(value, this.numerator), this.denominator);
    }

    public LongFraction multiply(LongFraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        if (other.equals(ZERO)) {
            return ZERO;
        }
        if (other.equals(ONE)) {
            return this;
        }
        return LongFraction.valueOf(Math.multiplyExact(this.numerator, other.numerator), Math.multiplyExact(this.denominator, other.denominator));
    }

    public LongFraction negate() {
        return LongFraction.valueOf(Math.negateExact(this.numerator), this.denominator);
    }

    public static LongFraction parse(String text) {
        Contract.checkArgument(text != null, "Text must not be null", new Object[0]);
        int separatorIndex = text.indexOf(47);
        if (separatorIndex == -1) {
            throw new NumberFormatException("Invalid fraction: " + text);
        }
        try {
            long numerator = Long.parseLong(text.substring(0, separatorIndex).trim());
            long denominator = Long.parseLong(text.substring(separatorIndex + 1).trim());
            if (denominator == 0L) {
                throw new NumberFormatException("Invalid fraction: " + text);
            }
            return new LongFraction(numerator, denominator);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new NumberFormatException("Invalid fraction: " + text);
        }
    }

    public LongFraction pow(int exponent) {
        if (exponent == 0) {
            return ONE;
        }
        if (exponent == 1) {
            return this;
        }
        if (exponent < 0) {
            return LongFraction.valueOf(MoreMath.powExact(this.denominator, -exponent), MoreMath.powExact(this.numerator, -exponent));
        }
        return LongFraction.valueOf(MoreMath.powExact(this.numerator, exponent), MoreMath.powExact(this.denominator, exponent));
    }

    public LongFraction reciprocal() {
        Contract.check(this.numerator != 0L, ArithmeticException.class, "Division by zero", new Object[0]);
        return LongFraction.valueOf(this.denominator, this.numerator);
    }

    public long round(RoundingMode roundingMode) {
        Contract.checkArgument(roundingMode != null, "Rounding mode must not be null", new Object[0]);
        return this.toBigDecimal(0, roundingMode).longValueExact();
    }

    public int signum() {
        return Long.signum(this.numerator);
    }

    public LongFraction subtract(long value) {
        if (value == 0L) {
            return this;
        }
        return LongFraction.valueOf(Math.subtractExact(this.numerator, Math.multiplyExact(value, this.denominator)), this.denominator);
    }

    public LongFraction subtract(LongFraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        if (other.equals(ZERO)) {
            return this;
        }
        if (this.denominator == other.denominator) {
            return LongFraction.valueOf(Math.subtractExact(this.numerator, other.numerator), this.denominator);
        }
        long commonDenominator = MoreMath.lcm(this.denominator, other.denominator);
        long numeratorCoefficient = commonDenominator / this.denominator;
        long otherNumeratorCoefficient = commonDenominator / other.denominator;
        return LongFraction.valueOf(Math.subtractExact(Math.multiplyExact(numeratorCoefficient, this.numerator), Math.multiplyExact(otherNumeratorCoefficient, other.numerator)), commonDenominator);
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator));
    }

    public BigDecimal toBigDecimal(int scale, RoundingMode roundingMode) {
        Contract.checkArgument(roundingMode != null, "Rounding mode must not be null", new Object[0]);
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), scale, roundingMode);
    }

    public String toString() {
        return String.format("%d/%d", this.numerator, this.denominator);
    }

    public static LongFraction valueOf(long value) {
        return new LongFraction(value, 1L);
    }

    public static LongFraction valueOf(long numerator, long denominator) {
        return new LongFraction(numerator, denominator);
    }

    private void normalizeAndReduce() {
        long reductor;
        if (this.numerator == 0L) {
            this.denominator = 1L;
            return;
        }
        if (this.denominator < 0L) {
            this.numerator = Math.negateExact(this.numerator);
            this.denominator = Math.negateExact(this.denominator);
        }
        if ((reductor = MoreMath.gcd(this.numerator, this.denominator)) > 1L) {
            this.numerator /= reductor;
            this.denominator /= reductor;
        }
    }
}

