/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.security.password;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.ToDoubleFunction;
import org.sellcom.core.Contract;
import org.sellcom.core.security.password.PasswordStrengthPolicy;

public class SyntaxRulesPasswordStrengthPolicy
implements PasswordStrengthPolicy {
    private double minScore = 0.0;
    private final Set<ToDoubleFunction<char[]>> rules = new LinkedHashSet<ToDoubleFunction<char[]>>();

    public SyntaxRulesPasswordStrengthPolicy create() {
        return new SyntaxRulesPasswordStrengthPolicy();
    }

    @Override
    public boolean test(char[] password) {
        Contract.checkArgument(password != null, "Password must not be null", new Object[0]);
        double score = 0.0;
        for (ToDoubleFunction<char[]> rule : this.rules) {
            score += rule.applyAsDouble(password);
        }
        return score >= this.minScore;
    }

    public SyntaxRulesPasswordStrengthPolicy withMinScore(double minScore) {
        Contract.checkArgument(minScore >= 0.0, "Minimum score must not be negative: {0}", minScore);
        this.minScore = minScore;
        return this;
    }

    public SyntaxRulesPasswordStrengthPolicy withRule(ToDoubleFunction<char[]> rule) {
        Contract.checkArgument(rule != null, "Rule must not be null", new Object[0]);
        this.rules.add(rule);
        return this;
    }
}

