/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.ThrowingFunction;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingBiFunction<T, U, R>
extends BiFunction<T, U, R> {
    @Override
    default public <V> ThrowingBiFunction<T, U, V> andThen(ThrowingFunction<? super R, ? extends V> after) {
        Contract.checkArgument(after != null, "After function must not be null", new Object[0]);
        return (former, latter) -> after.apply((R)this.apply(former, latter));
    }

    @Override
    default public R apply(T former, U latter) {
        try {
            return this.applyThrowing(former, latter);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public R applyThrowing(T var1, U var2) throws Exception;

    default public BiFunction<T, U, R> fallbackTo(BiFunction<T, U, R> fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public BiFunction<T, U, R> fallbackTo(BiFunction<T, U, R> fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback function must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.apply(former, latter);
            }
        };
    }

    default public BiFunction<T, U, R> orReturn(R value) {
        return this.orReturn(value, null);
    }

    default public BiFunction<T, U, R> orReturn(R value, Consumer<Exception> exceptionConsumer) {
        return (former, latter) -> {
            try {
                return this.applyThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingBiFunction<T, U, R> orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingBiFunction<T, U, R> orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyThrowing(former, latter);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingBiFunction<T, U, R> orTryWith(ThrowingBiFunction<? super T, ? super U, ? extends R> other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingBiFunction<T, U, R> orTryWith(ThrowingBiFunction<? super T, ? super U, ? extends R> other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other function must not be null", new Object[0]);
        return (former, latter) -> {
            try {
                return this.applyThrowing(former, latter);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyThrowing(former, latter);
            }
        };
    }
}

