/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingIntSupplier
extends IntSupplier {
    default public IntSupplier fallbackTo(IntSupplier fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public IntSupplier fallbackTo(IntSupplier fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback supplier must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsIntThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.getAsInt();
            }
        };
    }

    @Override
    default public int getAsInt() {
        try {
            return this.getAsIntThrowing();
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public int getAsIntThrowing() throws Exception;

    default public DoubleSupplier orReturn(double value) {
        return this.orReturn(value, null);
    }

    default public DoubleSupplier orReturn(double value, Consumer<Exception> exceptionConsumer) {
        return () -> {
            try {
                return this.getAsIntThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingIntSupplier orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsIntThrowing();
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingIntSupplier orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsIntThrowing();
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingIntSupplier orTryWith(ThrowingIntSupplier other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingIntSupplier orTryWith(ThrowingIntSupplier other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other supplier must not be null", new Object[0]);
        return () -> {
            try {
                return this.getAsIntThrowing();
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.getAsIntThrowing();
            }
        };
    }
}

