/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.LongUnaryOperator;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingLongUnaryOperator
extends LongUnaryOperator {
    default public ThrowingLongUnaryOperator andThen(ThrowingLongUnaryOperator after) {
        Contract.checkArgument(after != null, "After operator must not be null", new Object[0]);
        return argument -> after.applyAsLongThrowing(this.applyAsLongThrowing(argument));
    }

    @Override
    default public long applyAsLong(long argument) {
        try {
            return this.applyAsLongThrowing(argument);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public long applyAsLongThrowing(long var1) throws Exception;

    default public ThrowingLongUnaryOperator compose(ThrowingLongUnaryOperator before) {
        Contract.checkArgument(before != null, "Before operator must not be null", new Object[0]);
        return argument -> this.applyAsLongThrowing(before.applyAsLongThrowing(argument));
    }

    default public LongUnaryOperator fallbackTo(LongUnaryOperator fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public LongUnaryOperator fallbackTo(LongUnaryOperator fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback operator must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsLongThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.applyAsLong(argument);
            }
        };
    }

    default public LongUnaryOperator orReturn(long value) {
        return this.orReturn(value, null);
    }

    default public LongUnaryOperator orReturn(long value, Consumer<Exception> exceptionConsumer) {
        return argument -> {
            try {
                return this.applyAsLongThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingLongUnaryOperator orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsLongThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingLongUnaryOperator orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsLongThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingLongUnaryOperator orTryWith(ThrowingLongUnaryOperator other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingLongUnaryOperator orTryWith(ThrowingLongUnaryOperator other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other operator must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsLongThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyAsLongThrowing(argument);
            }
        };
    }
}

