/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core;

import java.util.Arrays;
import java.util.Locale;
import org.sellcom.core.Contract;
import org.sellcom.core.util.MoreArrays;

public class Strings {
    private Strings() {
    }

    public static String center(String string, int targetLength, char padding) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(targetLength >= 0, "Target length must not be negative", new Object[0]);
        if (string.length() >= targetLength) {
            return string;
        }
        StringBuilder builder = new StringBuilder(targetLength);
        int padStart = (targetLength - string.length()) / 2;
        for (int i = 0; i < padStart; ++i) {
            builder.append(padding);
        }
        builder.append(string);
        int padEnd = targetLength - builder.length();
        for (int i = 0; i < padEnd; ++i) {
            builder.append(padding);
        }
        return builder.toString();
    }

    public static String commonPrefix(String first, String ... other) {
        int offset;
        Contract.checkArgument(first != null, "First strings must not be null", new Object[0]);
        if (other == null) {
            return first;
        }
        Contract.checkArgument(!MoreArrays.contains(other, null), "Other strings must not contain null", new Object[0]);
        int maxPrefixLength = Math.min(first.length(), Arrays.stream(other).mapToInt(String::length).min().getAsInt());
        block0: for (offset = 0; offset < maxPrefixLength; ++offset) {
            for (String currentString : other) {
                if (currentString.charAt(offset) != first.charAt(offset)) break block0;
            }
        }
        return first.substring(0, offset);
    }

    public static String commonSuffix(String first, String ... other) {
        int offset;
        Contract.checkArgument(first != null, "First strings must not be null", new Object[0]);
        if (other == null) {
            return first;
        }
        Contract.checkArgument(!MoreArrays.contains(other, null), "Other strings must not contain null", new Object[0]);
        int maxPrefixLength = Math.min(first.length(), Arrays.stream(other).mapToInt(String::length).min().getAsInt());
        block0: for (offset = 0; offset < maxPrefixLength; ++offset) {
            for (String currentString : other) {
                if (currentString.charAt(currentString.length() - offset - 1) != first.charAt(first.length() - offset - 1)) break block0;
            }
        }
        return first.substring(first.length() - offset);
    }

    public static String emptyToNull(String string) {
        return Strings.isNullOrEmpty(string) ? null : string;
    }

    public static boolean endsWith(String string, String suffix, boolean ignoreCase) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(suffix != null, "Suffix must not be null", new Object[0]);
        return string.regionMatches(ignoreCase, string.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static String ensurePrefix(String string, String prefix) {
        return Strings.ensurePrefix(string, prefix, false);
    }

    public static String ensurePrefix(String string, String prefix, boolean ignoreCase) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(prefix != null, "Prefix must not be null", new Object[0]);
        if (!Strings.startsWith(string, prefix, ignoreCase)) {
            return prefix + string;
        }
        return string;
    }

    public static String ensureSuffix(String string, String suffix) {
        return Strings.ensureSuffix(string, suffix, false);
    }

    public static String ensureSuffix(String string, String suffix, boolean ignoreCase) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(suffix != null, "Suffix must not be null", new Object[0]);
        if (!Strings.endsWith(string, suffix, ignoreCase)) {
            return string + suffix;
        }
        return string;
    }

    public static String interleavePadding(String string, String padding) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(padding != null, "Padding must not be null", new Object[0]);
        StringBuilder builder = new StringBuilder();
        string.codePoints().forEach(codePoint -> {
            builder.appendCodePoint(codePoint);
            builder.append(padding);
        });
        builder.setLength(builder.length() - 1);
        return builder.toString();
    }

    public static boolean isBlank(String string) {
        int currentCodePoint;
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        int length = string.length();
        for (int offset = 0; offset < length; offset += Character.charCount(currentCodePoint)) {
            currentCodePoint = string.codePointAt(offset);
            if (Character.isWhitespace(currentCodePoint)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String normalizeWhitespace(String string) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        String result = string.trim();
        result = result.replaceAll("(?U)\\p{Space}+", " ");
        return result;
    }

    public static String nullToEmpty(String string) {
        return string == null ? "" : string;
    }

    public static String padEnd(String string, int minLength, char padding) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(minLength >= 0, "Minimum length must not be negative", new Object[0]);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder builder = new StringBuilder(minLength);
        builder.append(string);
        for (int i = string.length(); i < minLength; ++i) {
            builder.append(padding);
        }
        return builder.toString();
    }

    public static String padStart(String string, int minLength, char padding) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(minLength >= 0, "Minimum length must not be negative", new Object[0]);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder builder = new StringBuilder(minLength);
        for (int i = string.length(); i < minLength; ++i) {
            builder.append(padding);
        }
        builder.append(string);
        return builder.toString();
    }

    public static String removePrefix(String string, String prefix) {
        return Strings.removePrefix(string, prefix, false);
    }

    public static String removePrefix(String string, String prefix, boolean ignoreCase) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(prefix != null, "Prefix must not be null", new Object[0]);
        int prefixPosition = 0;
        if (string.regionMatches(ignoreCase, prefixPosition, prefix, 0, prefix.length())) {
            return string.substring(prefix.length());
        }
        return string;
    }

    public static String removeSuffix(String string, String suffix) {
        return Strings.removeSuffix(string, suffix, false);
    }

    public static String removeSuffix(String string, String suffix, boolean ignoreCase) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(suffix != null, "Suffix must not be null", new Object[0]);
        int suffixPosition = string.length() - suffix.length();
        if (string.regionMatches(ignoreCase, suffixPosition, suffix, 0, suffix.length())) {
            return string.substring(0, suffixPosition);
        }
        return string;
    }

    public static String removeWhitespace(String string) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        return string.replaceAll("(?U)\\p{Space}+", "");
    }

    public static String repeat(String string, int count) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(count >= 0, "Count must not be negative", new Object[0]);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            builder.append(string);
        }
        return builder.toString();
    }

    public static boolean startsWith(String string, String prefix, boolean ignoreCase) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        Contract.checkArgument(prefix != null, "Prefix must not be null", new Object[0]);
        return string.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static String toLowerCase(String string) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        return string.toLowerCase(Locale.ROOT);
    }

    public static String toUpperCase(String string) {
        Contract.checkArgument(string != null, "String must not be null", new Object[0]);
        return string.toUpperCase(Locale.ROOT);
    }
}

