/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.i18n;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;
import org.sellcom.core.i18n.PluralizationRules;
import org.sellcom.core.i18n.ResourceNotFoundException;

public class Resources {
    private static final Pattern REFERENCE_PATTERN = Pattern.compile("\\{@(?<referencedKey>[^}]*)\\}");
    private static final Map<Locale, Map<String, String>> REGISTERED_MAPPINGS = new HashMap<Locale, Map<String, String>>();

    private Resources() {
    }

    public static void clearResources() {
        Resources.clearResources(Locale.getDefault());
    }

    public static void clearResources(Locale locale) {
        Contract.checkArgument(locale != null, "Locale must not be null", new Object[0]);
        Resources.getRegisteredMappings(locale).clear();
    }

    public static String getQuantityString(String key, int quantity, Object ... args) {
        return Resources.getQuantityString(Locale.getDefault(), key, quantity, args);
    }

    public static String getQuantityString(Locale locale, String key, int quantity, Object ... args) {
        Contract.checkArgument(locale != null, "Locale must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(key), "Key must not be null or empty", new Object[0]);
        return Resources.getString(locale, key + PluralizationRules.getSuffix(locale, key, quantity), args);
    }

    public static String getString(Locale locale, String key, Object ... args) {
        Contract.checkArgument(locale != null, "Locale must not be null", new Object[0]);
        Contract.checkArgument(!Strings.isNullOrEmpty(key), "Key must not be null or empty", new Object[0]);
        Map<String, String> registeredMappings = Resources.getRegisteredMappings(locale);
        String value = registeredMappings.get(key);
        if (value == null) {
            throw new ResourceNotFoundException(String.format("Resource not found: %s", key));
        }
        if (args != null) {
            value = MessageFormat.format(value, args);
        }
        return value;
    }

    public static String getString(String key, Object ... args) {
        return Resources.getString(Locale.getDefault(), key, args);
    }

    public static void loadResources(String baseName) {
        Resources.registerMappingsForLocale(Locale.getDefault(), Resources.toMap(ResourceBundle.getBundle(baseName, Locale.getDefault())));
    }

    public static void loadResources(String baseName, Locale locale) {
        Resources.registerMappingsForLocale(locale, Resources.toMap(ResourceBundle.getBundle(baseName, locale)));
    }

    public static void loadResources(String baseName, Locale locale, ClassLoader classLoader) {
        Resources.registerMappingsForLocale(locale, Resources.toMap(ResourceBundle.getBundle(baseName, locale, classLoader)));
    }

    private static Map<String, String> getRegisteredMappings(Locale locale) {
        Map<String, String> registeredMappings = REGISTERED_MAPPINGS.get(locale);
        if (registeredMappings == null) {
            registeredMappings = new HashMap<String, String>();
            REGISTERED_MAPPINGS.put(locale, registeredMappings);
        }
        return registeredMappings;
    }

    private static void registerMapping(Map<String, String> registeredMappings, String key, String value) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = REFERENCE_PATTERN.matcher(value);
        while (matcher.find()) {
            String referencedKey = matcher.group("referencedKey");
            String referencedValue = registeredMappings.get(referencedKey);
            if (referencedValue == null) {
                throw new ResourceNotFoundException(String.format("Resource not found: %s", key));
            }
            matcher.appendReplacement(stringBuffer, referencedValue);
        }
        matcher.appendTail(stringBuffer);
        registeredMappings.put(key, stringBuffer.toString());
    }

    private static void registerMappingsForLocale(Locale locale, Map<String, String> pendingMappings) {
        Map.Entry<String, String> mapping;
        Map<String, String> registeredMappings = Resources.getRegisteredMappings(locale);
        LinkedHashSet<String> keysReferencedFromPendingMappings = new LinkedHashSet<String>();
        Iterator<Map.Entry<String, String>> iterator = pendingMappings.entrySet().iterator();
        while (iterator.hasNext()) {
            mapping = iterator.next();
            Matcher matcher = REFERENCE_PATTERN.matcher(mapping.getValue());
            if (matcher.find()) {
                do {
                    String referencedKey;
                    if (registeredMappings.containsKey(referencedKey = matcher.group("referencedKey"))) continue;
                    keysReferencedFromPendingMappings.add(referencedKey);
                } while (matcher.find());
                continue;
            }
            registeredMappings.put(mapping.getKey(), mapping.getValue());
            iterator.remove();
        }
        iterator = keysReferencedFromPendingMappings.iterator();
        while (iterator.hasNext()) {
            String key = (String)((Object)iterator.next());
            Resources.registerMapping(registeredMappings, key, registeredMappings.get(key));
            iterator.remove();
        }
        iterator = pendingMappings.entrySet().iterator();
        while (iterator.hasNext()) {
            mapping = iterator.next();
            Resources.registerMapping(registeredMappings, mapping.getKey(), mapping.getValue());
            iterator.remove();
        }
    }

    private static HashMap<String, String> toMap(ResourceBundle bundle) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, bundle.getString(key));
        }
        return map;
    }
}

