/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.internal.io.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import java.util.TreeMap;
import org.sellcom.core.collection.Iterables;

public abstract class SingleByteEncodedCharset
extends Charset {
    private final int[] decodeTable;
    private final SparseIntArray encodeTable;

    protected SingleByteEncodedCharset(String canonicalName, String[] aliases, int[] decodeTable) {
        super(canonicalName, aliases);
        this.decodeTable = decodeTable;
        this.encodeTable = SingleByteEncodedCharset.createEncodeTable(decodeTable);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static SparseIntArray createEncodeTable(int[] decodeTable) {
        TreeMap<Integer, Integer> mappings = new TreeMap<Integer, Integer>();
        int j = decodeTable.length;
        for (int i = 0; i < j; ++i) {
            if (decodeTable[i] == -1) continue;
            mappings.put(decodeTable[i], i);
        }
        SparseIntArray encodeTable = new SparseIntArray();
        SparseIntArray.access$102(encodeTable, SingleByteEncodedCharset.toIntArray(mappings.keySet()));
        SparseIntArray.access$202(encodeTable, SingleByteEncodedCharset.toIntArray(mappings.values()));
        return encodeTable;
    }

    private static int[] toIntArray(Iterable<Integer> iterable) {
        return Iterables.stream(iterable).mapToInt(Integer::intValue).toArray();
    }

    private static class SparseIntArray {
        private int[] indices;
        private int[] values;

        private SparseIntArray() {
        }

        private int get(int index) {
            int valueIndex = Arrays.binarySearch(this.indices, index);
            return valueIndex == -1 ? -1 : this.values[valueIndex];
        }

        static /* synthetic */ int[] access$102(SparseIntArray x0, int[] x1) {
            x0.indices = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(SparseIntArray x0, int[] x1) {
            x0.values = x1;
            return x1;
        }
    }

    private class Encoder
    extends CharsetEncoder {
        protected Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer source, ByteBuffer destination) {
            int sourceRemaining = source.remaining();
            int destinationRemaining = destination.remaining();
            while (sourceRemaining > 0) {
                if (destinationRemaining < 1) {
                    return CoderResult.OVERFLOW;
                }
                char currentChar = source.get();
                int currentByte = SingleByteEncodedCharset.this.encodeTable.get(currentChar);
                if (currentByte == -1) {
                    source.position(source.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                destination.put((byte)currentByte);
                --sourceRemaining;
                --destinationRemaining;
            }
            return CoderResult.UNDERFLOW;
        }
    }

    private class Decoder
    extends CharsetDecoder {
        protected Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer source, CharBuffer destination) {
            int sourceRemaining = source.remaining();
            int destinationRemaining = destination.remaining();
            while (sourceRemaining > 0) {
                if (destinationRemaining < 1) {
                    return CoderResult.OVERFLOW;
                }
                int currentByte = Byte.toUnsignedInt(source.get());
                int currentChar = SingleByteEncodedCharset.this.decodeTable[currentByte];
                if (currentChar == -1) {
                    source.position(source.position() - 1);
                    return CoderResult.malformedForLength(1);
                }
                destination.put((char)currentChar);
                --sourceRemaining;
                --destinationRemaining;
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

