/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.internal.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.math.RationalBigDecimal;

public class MathEvaluators {
    private MathEvaluators() {
    }

    public static BigDecimal evaluateMaclaughin(BiFunction<BigDecimal, Integer, RationalBigDecimal> termFunction, BigDecimal x, int scale) {
        RationalBigDecimal currentTerm;
        Contract.checkArgument(termFunction != null, "Term function must not be null", new Object[0]);
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(scale + 1);
        RationalBigDecimal value = RationalBigDecimal.ZERO;
        int i = 0;
        do {
            currentTerm = termFunction.apply(x, i);
            ++i;
            value = value.add(currentTerm);
        } while (currentTerm.toBigDecimal(scale + 3).abs().compareTo(acceptableError) > 0);
        return value.toBigDecimal(scale);
    }

    public static BigDecimal evaluateNewtonRaphson(Function<BigDecimal, BigDecimal> termFunction, BigDecimal x, BigDecimal initialGuess, int scale) {
        BigDecimal currentTerm;
        Contract.checkArgument(termFunction != null, "Term function must not be null", new Object[0]);
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        Contract.checkArgument(initialGuess != null, "Initial guess must not be null", new Object[0]);
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(scale + 1);
        BigDecimal value = initialGuess;
        do {
            currentTerm = termFunction.apply(value);
            value = value.subtract(currentTerm);
        } while (currentTerm.abs().compareTo(acceptableError) > 0);
        return value.setScale(scale, RoundingMode.HALF_UP);
    }
}

