/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.io;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;
import org.sellcom.core.util.platform.Os;

public class MorePaths {
    private MorePaths() {
    }

    public static Path canonicalize(Path path) {
        Contract.checkArgument(path != null, "Path must not be null", new Object[0]);
        return path.toAbsolutePath().normalize();
    }

    public static String getFileExtension(Path path) {
        String fileName = MorePaths.getFileName(path);
        int lastDot = fileName.lastIndexOf(46);
        return lastDot > 0 ? fileName.substring(lastDot + 1) : "";
    }

    public static String getFileName(Path path) {
        Contract.checkArgument(path != null, "Path must not be null", new Object[0]);
        Path fileName = path.getFileName();
        return fileName != null ? fileName.toString() : "";
    }

    public static String getFileNameWithoutExtension(Path path) {
        String fileName = MorePaths.getFileName(path);
        int lastDot = fileName.lastIndexOf(46);
        return lastDot > 0 ? fileName.substring(0, lastDot) : fileName;
    }

    public static Path getJavaHomeDirectory() {
        return Paths.get(System.getProperty("java.home"), new String[0]);
    }

    public static Path getUserCacheDirectory(String appName) {
        Contract.checkArgument(!Strings.isNullOrEmpty(appName), "Application name must not be null or empty", new Object[0]);
        if (Os.isWindows()) {
            return MorePaths.getUserRoamingProfileDirectory().resolve(appName).resolve("Cache");
        }
        Path userHomeDirectory = MorePaths.getUserHomeDirectory();
        if (Os.isLinux()) {
            return userHomeDirectory.resolve(".cache").resolve(appName);
        }
        if (Os.isMacOs()) {
            return userHomeDirectory.resolve("Library").resolve("Caches").resolve(appName);
        }
        return userHomeDirectory;
    }

    public static Path getUserConfigDirectory(String appName) {
        Contract.checkArgument(!Strings.isNullOrEmpty(appName), "Application name must not be null or empty", new Object[0]);
        if (Os.isWindows()) {
            return MorePaths.getUserRoamingProfileDirectory().resolve(appName);
        }
        Path userHomeDirectory = MorePaths.getUserHomeDirectory();
        if (Os.isLinux()) {
            return userHomeDirectory.resolve(".config").resolve(appName);
        }
        if (Os.isMacOs()) {
            return userHomeDirectory.resolve("Library").resolve("Application Support").resolve(appName);
        }
        return userHomeDirectory;
    }

    public static Path getUserDataDirectory(String appName) {
        Contract.checkArgument(!Strings.isNullOrEmpty(appName), "Application name must not be null or empty", new Object[0]);
        if (Os.isWindows()) {
            return MorePaths.getUserRoamingProfileDirectory().resolve(appName);
        }
        Path userHomeDirectory = MorePaths.getUserHomeDirectory();
        if (Os.isLinux()) {
            return userHomeDirectory.resolve(".local").resolve("share").resolve(appName);
        }
        if (Os.isMacOs()) {
            return userHomeDirectory.resolve("Library").resolve("Application Support").resolve(appName);
        }
        return userHomeDirectory;
    }

    public static Path getUserHomeDirectory() {
        return Paths.get(System.getProperty("user.home"), new String[0]);
    }

    public static Path getUserLogDirectory(String appName) {
        Contract.checkArgument(!Strings.isNullOrEmpty(appName), "Application name must not be null or empty", new Object[0]);
        if (Os.isWindows()) {
            return MorePaths.getUserRoamingProfileDirectory().resolve(appName).resolve("Logs");
        }
        Path userHomeDirectory = MorePaths.getUserHomeDirectory();
        if (Os.isLinux()) {
            return userHomeDirectory.resolve(".cache").resolve(appName).resolve("logs");
        }
        if (Os.isMacOs()) {
            return userHomeDirectory.resolve("Library").resolve("Logs");
        }
        return userHomeDirectory;
    }

    public static Path getWorkingDirectory() {
        return Paths.get("", new String[0]);
    }

    private static Path getUserRoamingProfileDirectory() {
        String appData = System.getenv("APPDATA");
        return Strings.isNullOrEmpty(appData) ? MorePaths.getUserHomeDirectory().resolve("AppData").resolve("Roaming") : Paths.get(appData, new String[0]);
    }
}

