/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.sellcom.core.Contract;
import org.sellcom.core.math.MoreMath;

public class Fraction
extends Number
implements Comparable<Fraction> {
    public static final Fraction ONE = Fraction.valueOf(1);
    public static final Fraction ONE_HALF = Fraction.valueOf(1, 2);
    public static final Fraction ONE_QUARTER = Fraction.valueOf(1, 4);
    public static final Fraction ONE_THIRD = Fraction.valueOf(1, 3);
    public static final Fraction THREE_QUARTERS = Fraction.valueOf(3, 4);
    public static final Fraction TWO_THIRDS = Fraction.valueOf(2, 3);
    public static final Fraction ZERO = Fraction.valueOf(0);
    private static final long serialVersionUID = 7020987637819229668L;
    private int denominator;
    private int numerator;

    private Fraction(int numerator, int denominator) {
        Contract.checkArgument(denominator != 0, "Denominator must not be zero", new Object[0]);
        this.numerator = numerator;
        this.denominator = denominator;
        this.normalizeAndReduce();
    }

    public Fraction abs() {
        return this.numerator < 0 ? Fraction.valueOf(MoreMath.absExact(this.numerator), this.denominator) : this;
    }

    public Fraction add(Fraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        if (other.equals(ZERO)) {
            return this;
        }
        if (this.denominator == other.denominator) {
            return Fraction.valueOf(Math.addExact(this.numerator, other.numerator), this.denominator);
        }
        int commonDenominator = MoreMath.lcm(this.denominator, other.denominator);
        int numeratorCoefficient = commonDenominator / this.denominator;
        int otherNumeratorCoefficient = commonDenominator / other.denominator;
        return Fraction.valueOf(Math.addExact(Math.multiplyExact(numeratorCoefficient, this.numerator), Math.multiplyExact(otherNumeratorCoefficient, other.numerator)), commonDenominator);
    }

    public Fraction add(int value) {
        if (value == 0) {
            return this;
        }
        return Fraction.valueOf(Math.addExact(this.numerator, Math.multiplyExact(value, this.denominator)), this.denominator);
    }

    @Override
    public int compareTo(Fraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        int reductor = MoreMath.gcd(this.denominator, other.denominator);
        return Integer.compare(Math.multiplyExact(this.numerator, other.denominator / reductor), Math.multiplyExact(this.denominator / reductor, other.numerator));
    }

    public Fraction divide(Fraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        Contract.check(!other.equals(ZERO), ArithmeticException.class, "Division by zero", new Object[0]);
        if (other.equals(ONE)) {
            return this;
        }
        return Fraction.valueOf(Math.multiplyExact(this.numerator, other.denominator), Math.multiplyExact(this.denominator, other.numerator));
    }

    public Fraction divide(int value) {
        Contract.check(value != 0, ArithmeticException.class, "Division by zero", new Object[0]);
        if (value == 1) {
            return this;
        }
        return Fraction.valueOf(this.numerator, Math.multiplyExact(value, this.denominator));
    }

    @Override
    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Fraction) {
            Fraction otherFraction = (Fraction)other;
            return this.numerator == otherFraction.numerator && this.denominator == otherFraction.denominator;
        }
        return false;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int hashCode() {
        return Objects.hash(this.numerator, this.denominator);
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    public boolean isInteger() {
        return this.denominator == 1;
    }

    public int intValueExact() {
        return MoreMath.toIntExact(this.doubleValue());
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    public long longValueExact() {
        return MoreMath.toLongExact(this.doubleValue());
    }

    public Fraction multiply(Fraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        if (other.equals(ZERO)) {
            return ZERO;
        }
        if (other.equals(ONE)) {
            return this;
        }
        return Fraction.valueOf(Math.multiplyExact(this.numerator, other.numerator), Math.multiplyExact(this.denominator, other.denominator));
    }

    public Fraction multiply(int value) {
        if (value == 0) {
            return ZERO;
        }
        if (value == 1) {
            return this;
        }
        return Fraction.valueOf(Math.multiplyExact(value, this.numerator), this.denominator);
    }

    public Fraction negate() {
        return Fraction.valueOf(Math.negateExact(this.numerator), this.denominator);
    }

    public static Fraction parse(String text) {
        Contract.checkArgument(text != null, "Text must not be null", new Object[0]);
        int separatorIndex = text.indexOf(47);
        if (separatorIndex == -1) {
            throw new NumberFormatException("Invalid fraction: " + text);
        }
        try {
            int numerator = Integer.parseInt(text.substring(0, separatorIndex).trim());
            int denominator = Integer.parseInt(text.substring(separatorIndex + 1).trim());
            if (denominator == 0) {
                throw new NumberFormatException("Invalid fraction: " + text);
            }
            return new Fraction(numerator, denominator);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new NumberFormatException("Invalid fraction: " + text);
        }
    }

    public Fraction pow(int exponent) {
        if (exponent == 0) {
            return ONE;
        }
        if (exponent == 1) {
            return this;
        }
        if (exponent < 0) {
            return Fraction.valueOf(MoreMath.powExact(this.denominator, -exponent), MoreMath.powExact(this.numerator, -exponent));
        }
        return Fraction.valueOf(MoreMath.powExact(this.numerator, exponent), MoreMath.powExact(this.denominator, exponent));
    }

    public Fraction reciprocal() {
        Contract.check(this.numerator != 0, ArithmeticException.class, "Division by zero", new Object[0]);
        return Fraction.valueOf(this.denominator, this.numerator);
    }

    public int round(RoundingMode roundingMode) {
        Contract.checkArgument(roundingMode != null, "Rounding mode must not be null", new Object[0]);
        return this.toBigDecimal(0, roundingMode).intValueExact();
    }

    public int signum() {
        return Integer.signum(this.numerator);
    }

    public Fraction subtract(Fraction other) {
        Contract.checkArgument(other != null, "Other fraction must not be null", new Object[0]);
        if (other.equals(ZERO)) {
            return this;
        }
        if (this.denominator == other.denominator) {
            return Fraction.valueOf(Math.subtractExact(this.numerator, other.numerator), this.denominator);
        }
        int commonDenominator = MoreMath.lcm(this.denominator, other.denominator);
        int numeratorCoefficient = commonDenominator / this.denominator;
        int otherNumeratorCoefficient = commonDenominator / other.denominator;
        return Fraction.valueOf(Math.subtractExact(Math.multiplyExact(numeratorCoefficient, this.numerator), Math.multiplyExact(otherNumeratorCoefficient, other.numerator)), commonDenominator);
    }

    public Fraction subtract(int value) {
        if (value == 0) {
            return this;
        }
        return Fraction.valueOf(Math.subtractExact(this.numerator, Math.multiplyExact(value, this.denominator)), this.denominator);
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator));
    }

    public BigDecimal toBigDecimal(int scale, RoundingMode roundingMode) {
        Contract.checkArgument(roundingMode != null, "Rounding mode must not be null", new Object[0]);
        return new BigDecimal(this.numerator).divide(new BigDecimal(this.denominator), scale, roundingMode);
    }

    public String toString() {
        return String.format("%d/%d", this.numerator, this.denominator);
    }

    public static Fraction valueOf(int value) {
        return new Fraction(value, 1);
    }

    public static Fraction valueOf(int numerator, int denominator) {
        return new Fraction(numerator, denominator);
    }

    private void normalizeAndReduce() {
        int reductor;
        if (this.numerator == 0) {
            this.denominator = 1;
            return;
        }
        if (this.denominator < 0) {
            this.numerator = Math.negateExact(this.numerator);
            this.denominator = Math.negateExact(this.denominator);
        }
        if ((reductor = MoreMath.gcd(this.numerator, this.denominator)) > 1) {
            this.numerator /= reductor;
            this.denominator /= reductor;
        }
    }
}

