/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.math.ExpMclaughlinEvaluator;
import org.sellcom.core.internal.math.MathEvaluators;
import org.sellcom.core.math.MoreMath;

public class SpecialFunctions {
    private SpecialFunctions() {
    }

    public static int ceilLd(int x) {
        Contract.checkArgument(x > 0, "X must be positive: {0}", x);
        return 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    public static long ceilLd(long x) {
        Contract.checkArgument(x > 0L, "X must be positive: {0}", x);
        return 64 - Long.numberOfLeadingZeros(x - 1L);
    }

    public static BigDecimal exp(BigDecimal x, int scale) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        if (x.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ONE;
        }
        if (x.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ONE.divide(SpecialFunctions.exp(x.negate(), scale), scale, RoundingMode.HALF_UP);
        }
        if (x.compareTo(BigDecimal.ONE) < 0) {
            return MathEvaluators.evaluateMaclaughin(new ExpMclaughlinEvaluator(), x, scale);
        }
        int internalScale = scale + 6;
        BigDecimal fractionalPart = MoreMath.fractionalPart(x);
        BigDecimal integralPart = MoreMath.integralPart(x);
        BigDecimal innerExponent = BigDecimal.ONE.add(fractionalPart.divide(integralPart, internalScale, RoundingMode.HALF_UP));
        BigDecimal result = MoreMath.pow(MathEvaluators.evaluateMaclaughin(new ExpMclaughlinEvaluator(), innerExponent, internalScale), integralPart.longValueExact(), internalScale);
        return result.setScale(scale, RoundingMode.HALF_UP);
    }

    public static int floorLd(int x) {
        Contract.checkArgument(x > 0, "X must be positive: {0}", x);
        return 32 - Integer.numberOfLeadingZeros(x) - 1;
    }

    public static long floorLd(long x) {
        Contract.checkArgument(x > 0L, "X must be positive: {0}", x);
        return (long)(64 - Long.numberOfLeadingZeros(x)) - 1L;
    }

    public static double ld(double x) {
        Contract.checkArgument(Double.isFinite(x), "X must be finite: {0}", x);
        return Math.log(x) / Math.log(2.0);
    }

    public static BigDecimal ln(BigDecimal x, int scale) {
        Contract.checkArgument(x != null, "X must not be null", new Object[0]);
        Contract.check(x.compareTo(BigDecimal.ZERO) > 0, ArithmeticException.class, "X must be positive: {0}", x);
        if (x.compareTo(BigDecimal.valueOf(1000L)) < 0) {
            int internalScale = scale + 3;
            return MathEvaluators.evaluateNewtonRaphson(y -> {
                BigDecimal eToY = SpecialFunctions.exp(y, internalScale);
                return eToY.subtract(x).divide(eToY, internalScale, RoundingMode.HALF_UP);
            }, x, x, scale);
        }
        int internalScale = scale + 3;
        int magnitudeOfX = MoreMath.magnitude(x);
        BigDecimal result = BigDecimal.valueOf(magnitudeOfX).multiply(SpecialFunctions.ln(MoreMath.root(x, magnitudeOfX, internalScale), internalScale));
        return result.setScale(scale, RoundingMode.HALF_UP);
    }

    public static double ln(double x) {
        Contract.checkArgument(Double.isFinite(x), "X must be finite: {0}", x);
        return Math.log(x);
    }
}

