/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.sellcom.core.Contract;
import org.sellcom.core.Threads;
import org.sellcom.core.io.Io;
import org.sellcom.core.net.NetworkEndPoint;
import org.sellcom.core.net.NetworkMessage;
import org.sellcom.core.net.NetworkReceiver;

public class DatagramReceiver
implements NetworkReceiver {
    private static final int DEFAULT_HANDLER_THREAD_PRIORITY = 5;
    private static final int DEFAULT_RECEIVE_BUFFER_SIZE = 8192;
    private static final int DEFAULT_RECEIVER_THREAD_PRIORITY = 5;
    private DatagramChannel channel;
    private final Map<InetAddress, MembershipKey> groups = new HashMap<InetAddress, MembershipKey>();
    private ExecutorService handlerExecutor;
    private int handlerThreadPriority = 5;
    private int handlerThreads = 1;
    private InetSocketAddress localEndPoint = new InetSocketAddress(0);
    private Consumer<NetworkMessage> messageConsumer;
    private NetworkInterface networkInterface;
    private final BlockingQueue<NetworkMessage> pendingMessages = new LinkedBlockingQueue<NetworkMessage>();
    private final ProtocolFamily protocolFamily;
    private int receiveBufferSize = 8192;
    private ExecutorService receiverExecutor;
    private int receiverThreadPriority = 5;
    private int receiverThreads = 1;
    private volatile NetworkEndPoint.State state = NetworkEndPoint.State.STOPPED;

    private DatagramReceiver(ProtocolFamily protocolFamily) {
        this.protocolFamily = protocolFamily;
    }

    public static DatagramReceiver create(ProtocolFamily protocolFamily) {
        Contract.checkArgument(protocolFamily != null, "Protocol family must not be null", new Object[0]);
        return new DatagramReceiver(protocolFamily);
    }

    public Set<InetAddress> getGroups() {
        return this.groups.keySet();
    }

    public int getHandlerThreadPriority() {
        return this.handlerThreadPriority;
    }

    public int getHandlerThreads() {
        return this.handlerThreads;
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.localEndPoint.getAddress();
    }

    @Override
    public InetSocketAddress getLocalEndPoint() {
        return this.localEndPoint;
    }

    @Override
    public int getLocalPort() {
        return this.localEndPoint.getPort();
    }

    @Override
    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    @Override
    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getReceiverThreadPriority() {
        return this.receiverThreadPriority;
    }

    public int getReceiverThreads() {
        return this.receiverThreads;
    }

    @Override
    public NetworkEndPoint.State getState() {
        return this.state;
    }

    @Override
    public void start() throws IOException {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Receiver has already been started", new Object[0]);
        this.state = NetworkEndPoint.State.STARTING;
        try {
            this.createChannel();
            this.startBackgroundThreads();
        }
        catch (IOException e) {
            this.state = NetworkEndPoint.State.STARTED;
            this.stop();
        }
        this.state = NetworkEndPoint.State.STARTED;
    }

    @Override
    public void stop() {
        if (this.state == NetworkEndPoint.State.STARTED) {
            this.state = NetworkEndPoint.State.STOPPING;
            this.stopBackgroundThreads();
            this.clearQueue();
            this.destroyChannel();
            this.state = NetworkEndPoint.State.STOPPED;
        }
    }

    public DatagramReceiver withHandlerThreadPriority(int threadPriority) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Receiver has already been started", new Object[0]);
        Contract.checkArgument(threadPriority >= 1 && threadPriority <= 10, "Thread priority must be valid: {0}", threadPriority);
        this.handlerThreadPriority = threadPriority;
        return this;
    }

    public DatagramReceiver withGroups(Set<InetAddress> groups) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Receiver has already been started", new Object[0]);
        Contract.checkArgument(groups != null, "Groups must not be null", new Object[0]);
        groups.forEach(group -> {
            MembershipKey cfr_ignored_0 = this.groups.put((InetAddress)group, (MembershipKey)null);
        });
        return this;
    }

    public DatagramReceiver withHandlerThreads(int threads) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Receiver has already been started", new Object[0]);
        Contract.checkArgument(threads > 0, "Number of threads must be positive: {0}", threads);
        this.handlerThreads = threads;
        return this;
    }

    public DatagramReceiver withLocalAddressAndPort(InetAddress localAddress, int localPort) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Receiver has already been started", new Object[0]);
        Contract.checkArgument(localAddress != null, "Local address must not be null", new Object[0]);
        Contract.checkArgument(localPort >= 0 && localPort <= 65535, "Local port must be valid: {0}", localPort);
        this.localEndPoint = new InetSocketAddress(localAddress, localPort);
        return this;
    }

    public DatagramReceiver withLocalPort(int localPort) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Receiver has already been started", new Object[0]);
        Contract.checkArgument(localPort >= 0 && localPort <= 65535, "Local port must be valid: {0}", localPort);
        this.localEndPoint = new InetSocketAddress(localPort);
        return this;
    }

    public DatagramReceiver withMessageConsumer(Consumer<NetworkMessage> messageConsumer) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Receiver has already been started", new Object[0]);
        Contract.checkArgument(messageConsumer != null, "Message consumer must not be null", new Object[0]);
        this.messageConsumer = messageConsumer;
        return this;
    }

    public DatagramReceiver withNetworkInterface(NetworkInterface networkInterface) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Receiver has already been started", new Object[0]);
        Contract.checkArgument(networkInterface != null, "Network interface must not be null", new Object[0]);
        this.networkInterface = networkInterface;
        return this;
    }

    public DatagramReceiver withReceiveBufferSize(int bufferSize) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Receiver has already been started", new Object[0]);
        Contract.checkArgument(bufferSize >= 0, "Buffer size must not be negative: {0}", bufferSize);
        this.receiveBufferSize = bufferSize;
        return this;
    }

    public DatagramReceiver withReceiverThreadPriority(int threadPriority) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Receiver has already been started", new Object[0]);
        Contract.checkArgument(threadPriority >= 1 && threadPriority <= 10, "Thread priority must be valid: {0}", threadPriority);
        this.receiverThreadPriority = threadPriority;
        return this;
    }

    public DatagramReceiver withReceiverThreads(int threads) {
        Contract.checkState(this.state == NetworkEndPoint.State.STOPPED, "Receiver has already been started", new Object[0]);
        Contract.checkArgument(threads > 0, "Number of threads must be positive: {0}", threads);
        this.receiverThreads = threads;
        return this;
    }

    private void clearQueue() {
        this.pendingMessages.clear();
    }

    private void createChannel() throws IOException {
        this.channel = DatagramChannel.open(this.protocolFamily);
        this.channel.configureBlocking(true);
        this.channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_LOOP, (Object)true);
        this.channel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.receiveBufferSize);
        this.channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
        this.channel.bind(this.localEndPoint);
        for (InetAddress group : this.groups.keySet()) {
            this.groups.put(group, this.channel.join(group, this.networkInterface));
        }
    }

    private Thread createHandlerThread(Runnable handler) {
        Thread thread = new Thread(handler);
        thread.setDaemon(true);
        thread.setName("DatagramSender.HandlerThread@" + System.identityHashCode(thread));
        thread.setPriority(this.handlerThreadPriority);
        return thread;
    }

    private Thread createReceiverThread(Runnable receiver) {
        Thread thread = new Thread(receiver);
        thread.setDaemon(true);
        thread.setName("DatagramSender.ReceiverThread@" + System.identityHashCode(thread));
        thread.setPriority(this.receiverThreadPriority);
        return thread;
    }

    private void destroyChannel() {
        this.groups.keySet().stream().map(group -> this.groups.put((InetAddress)group, (MembershipKey)null)).filter(((Predicate<MembershipKey>)Objects::isNull).negate()).forEach(MembershipKey::drop);
        Io.close(this.channel);
    }

    private void startBackgroundThreads() {
        int i;
        this.handlerExecutor = Executors.newFixedThreadPool(this.handlerThreads, this::createHandlerThread);
        for (i = 0; i < this.handlerThreads; ++i) {
            this.handlerExecutor.submit(new Handler());
        }
        this.receiverExecutor = Executors.newFixedThreadPool(this.receiverThreads, this::createReceiverThread);
        for (i = 0; i < this.receiverThreads; ++i) {
            this.receiverExecutor.submit(new Receiver());
        }
    }

    private void stopBackgroundThreads() {
        this.receiverExecutor.shutdownNow();
        this.handlerExecutor.shutdownNow();
    }

    private class Receiver
    implements Runnable {
        private Receiver() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ByteBuffer buffer = ByteBuffer.allocate(DatagramReceiver.this.receiveBufferSize);
            while (!Thread.interrupted()) {
                try {
                    SocketAddress remoteAddress = DatagramReceiver.this.channel.receive(buffer);
                    buffer.flip();
                    if (remoteAddress instanceof InetSocketAddress && DatagramReceiver.this.pendingMessages.offer(NetworkMessage.fromByteBuffer(buffer, (InetSocketAddress)remoteAddress))) {
                        // empty if block
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                buffer.clear();
            }
            return;
        }
    }

    private class Handler
    implements Runnable {
        private Handler() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    DatagramReceiver.this.messageConsumer.accept((NetworkMessage)DatagramReceiver.this.pendingMessages.take());
                }
                catch (InterruptedException e) {
                    Threads.preserveInterruptedStatus(e);
                }
            }
        }
    }
}

