/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingConsumer<T>
extends Consumer<T> {
    @Override
    default public void accept(T argument) {
        try {
            this.acceptThrowing(argument);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public void acceptThrowing(T var1) throws Exception;

    default public Consumer<T> fallbackTo(Consumer<T> fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public Consumer<T> fallbackTo(Consumer<T> fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback consumer must not be null", new Object[0]);
        return argument -> {
            try {
                this.acceptThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                fallback.accept(argument);
            }
        };
    }

    default public ThrowingConsumer<T> orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                this.acceptThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingConsumer<T> orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                this.acceptThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingConsumer<T> orTryWith(ThrowingConsumer<? super T> other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingConsumer<T> orTryWith(ThrowingConsumer<? super T> other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other consumer must not be null", new Object[0]);
        return argument -> {
            try {
                this.acceptThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                other.acceptThrowing(argument);
            }
        };
    }
}

