/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.function;

import java.util.function.Consumer;
import java.util.function.IntToDoubleFunction;
import org.sellcom.core.Contract;
import org.sellcom.core.internal.ReflectionUtils;
import org.sellcom.core.util.function.UncheckedException;

@FunctionalInterface
public interface ThrowingIntToDoubleFunction
extends IntToDoubleFunction {
    @Override
    default public double applyAsDouble(int argument) {
        try {
            return this.applyAsDoubleThrowing(argument);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw UncheckedException.wrap(e);
        }
    }

    public double applyAsDoubleThrowing(int var1) throws Exception;

    default public IntToDoubleFunction fallbackTo(IntToDoubleFunction fallback) {
        return this.fallbackTo(fallback, null);
    }

    default public IntToDoubleFunction fallbackTo(IntToDoubleFunction fallback, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(fallback != null, "Fallback function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return fallback.applyAsDouble(argument);
            }
        };
    }

    default public IntToDoubleFunction orReturn(double value) {
        return this.orReturn(value, null);
    }

    default public IntToDoubleFunction orReturn(double value, Consumer<Exception> exceptionConsumer) {
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return value;
            }
        };
    }

    default public ThrowingIntToDoubleFunction orThrow(Class<? extends RuntimeException> exceptionClass) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, e);
            }
        };
    }

    default public ThrowingIntToDoubleFunction orThrow(Class<? extends RuntimeException> exceptionClass, String message) {
        Contract.checkArgument(exceptionClass != null, "Exception class must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                throw (RuntimeException)ReflectionUtils.createException(exceptionClass, message, e);
            }
        };
    }

    default public ThrowingIntToDoubleFunction orTryWith(ThrowingIntToDoubleFunction other) {
        return this.orTryWith(other, null);
    }

    default public ThrowingIntToDoubleFunction orTryWith(ThrowingIntToDoubleFunction other, Consumer<Exception> exceptionConsumer) {
        Contract.checkArgument(other != null, "Other function must not be null", new Object[0]);
        return argument -> {
            try {
                return this.applyAsDoubleThrowing(argument);
            }
            catch (Exception e) {
                if (exceptionConsumer != null) {
                    exceptionConsumer.accept(e);
                }
                return other.applyAsDoubleThrowing(argument);
            }
        };
    }
}

