/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.geography;

import java.util.Objects;
import org.sellcom.core.Contract;

public class GeoBounds {
    private final double east;
    private final double north;
    private final double south;
    private final double west;

    public GeoBounds(double south, double north, double west, double east) {
        Contract.checkArgument(south >= -90.0, "South must not be less than -90.0: {0}", south);
        Contract.checkArgument(south <= 90.0, "South must not be greater than +90.0: {0}", south);
        Contract.checkArgument(north >= -90.0, "North must not be less than -90.0: {0}", north);
        Contract.checkArgument(north <= 90.0, "North must not be greater than +90.0: {0}", north);
        Contract.checkArgument(west >= -180.0, "West must not be less than -180.0: {0}", west);
        Contract.checkArgument(west <= 180.0, "West must not be greater than +180.0: {0}", west);
        Contract.checkArgument(east >= -180.0, "East must not be less than -180.0: {0}", east);
        Contract.checkArgument(east <= 180.0, "East must not be greater than +180.0: {0}", east);
        this.north = north;
        this.south = south;
        this.east = east;
        this.west = west;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof GeoBounds) {
            GeoBounds otherBounds = (GeoBounds)other;
            return Objects.equals(this.south, otherBounds.south) && Objects.equals(this.north, otherBounds.north) && Objects.equals(this.west, otherBounds.west) && Objects.equals(this.east, otherBounds.east);
        }
        return false;
    }

    public double getEast() {
        return this.east;
    }

    public double getNorth() {
        return this.north;
    }

    public double getSouth() {
        return this.south;
    }

    public double getWest() {
        return this.west;
    }

    public int hashCode() {
        return Objects.hash(this.south, this.north, this.west, this.east);
    }

    public String toString() {
        return String.format("[%f,%f,%f,%f]", this.south, this.north, this.west, this.east);
    }
}

