/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.core.util.geography;

import java.util.Objects;
import org.sellcom.core.Contract;
import org.sellcom.core.math.MoreMath;

public class GeoPoint {
    private final double latitude;
    private final double longitude;

    public GeoPoint(double latitude, double longitude) {
        Contract.checkArgument(latitude >= -90.0, "Latitude must not be less than -90.0: {0}", latitude);
        Contract.checkArgument(latitude <= 90.0, "Latitude must not be greater than +90.0: {0}", latitude);
        Contract.checkArgument(longitude >= -180.0, "Latitude must not be less than -180.0: {0}", longitude);
        Contract.checkArgument(longitude <= 180.0, "Latitude must not be greater than +180.0: {0}", longitude);
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof GeoPoint) {
            GeoPoint otherPoint = (GeoPoint)other;
            return MoreMath.equals(this.latitude, otherPoint.latitude, 0.0) && MoreMath.equals(this.longitude, otherPoint.longitude, 0.0);
        }
        return false;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }

    public String toString() {
        return String.format("[%f,%f]", this.latitude, this.longitude);
    }
}

