/*
 * Copyright (c) 2015-2017 Petr Zelenka <petr.zelenka@sellcom.org>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sellcom.javafx.scene.control;

import static org.sellcom.core.i18n.Resources.getString;

import javafx.scene.control.ButtonBar.ButtonData;
import javafx.scene.control.ButtonType;

/**
 * More standard button types.
 *
 * @since 1.0
 *
 * @see ButtonType
 */
public class MoreButtonTypes {

	public static final ButtonType ADD = new ButtonType(getString("buttons.add.title"), ButtonData.LEFT);

	public static final ButtonType APPLY = new ButtonType(getString("buttons.apply.title"), ButtonData.APPLY);

	public static final ButtonType CANCEL = new ButtonType(getString("buttons.cancel.title"), ButtonData.CANCEL_CLOSE);

	public static final ButtonType CLOSE = new ButtonType(getString("buttons.close.title"), ButtonData.CANCEL_CLOSE);

	public static final ButtonType CONFIRM = new ButtonType(getString("buttons.confirm.title"), ButtonData.OK_DONE);

	public static final ButtonType CONTINUE = new ButtonType(getString("buttons.continue.title"), ButtonData.OK_DONE);

	public static final ButtonType CREATE = new ButtonType(getString("buttons.create.title"), ButtonData.LEFT);

	public static final ButtonType DUPLICATE = new ButtonType(getString("buttons.duplicate.title"), ButtonData.LEFT);

	public static final ButtonType EDIT = new ButtonType(getString("buttons.edit.title"), ButtonData.LEFT);

	public static final ButtonType EXPORT = new ButtonType(getString("buttons.export.title"), ButtonData.LEFT);

	public static final ButtonType FINISH = new ButtonType(getString("buttons.finish.title"), ButtonData.FINISH);

	public static final ButtonType IMPORT = new ButtonType(getString("buttons.import.title"), ButtonData.LEFT);

	public static final ButtonType NEXT = new ButtonType(getString("buttons.next.title"), ButtonData.NEXT_FORWARD);

	public static final ButtonType NO = new ButtonType(getString("buttons.no.title"), ButtonData.NO);

	public static final ButtonType PREVIOUS = new ButtonType(getString("buttons.previous.title"), ButtonData.BACK_PREVIOUS);

	public static final ButtonType QUIT = new ButtonType(getString("buttons.quit.title"), ButtonData.CANCEL_CLOSE);

	public static final ButtonType REMOVE = new ButtonType(getString("buttons.remove.title"), ButtonData.LEFT);

	public static final ButtonType YES = new ButtonType(getString("buttons.yes.title"), ButtonData.YES);


	private MoreButtonTypes() {
		// Namespace for constants, not to be instantiated
	}

}
