/*
 * Copyright (c) 2015-2017 Petr Zelenka <petr.zelenka@sellcom.org>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sellcom.javafx.stage;

import org.sellcom.core.Contract;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;

/**
 * Operations with dialogs.
 *
 * @since 1.0
 */
public class Dialogs {

	private Dialogs() {
		// Utility class, not to be instantiated
	}


	/**
	 * Registers a button with the given type with the given dialog.
	 *
	 * @throws IllegalArgumentException if {@code dialog} is {@code null}
	 * @throws IllegalArgumentException if {@code type} is {@code null}
	 *
	 * @since 1.0
	 */
	public static void registerButton(Dialog<?> dialog, ButtonType type, boolean shallCloseDialog) {
		Contract.checkArgument(dialog != null, "Dialog must not be null");
		Contract.checkArgument(type != null, "Button type must not be null");

		DialogPane dialogPane = dialog.getDialogPane();
		dialogPane.getButtonTypes().add(type);

		if (!shallCloseDialog) {
			Button button = (Button) dialogPane.lookupButton(type);
			button.addEventFilter(ActionEvent.ACTION, event -> {
				EventHandler<ActionEvent> handler = button.getOnAction();
				if (handler != null) {
					handler.handle(event);
				}

				event.consume();
			});
		}
	}

}
