/*
 * Copyright (c) 2015-2017 Petr Zelenka <petr.zelenka@sellcom.org>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sellcom.javafx.stage;

import static javafx.scene.layout.Priority.ALWAYS;

import org.sellcom.core.Exceptions;
import org.sellcom.javafx.scene.control.MoreButtonTypes;

import javafx.application.Platform;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.stage.Window;

/**
 * Error dialog.
 *
 * @since 1.0
 */
public class ErrorDialog extends Dialog<Void> {

	private static final int STACK_TRACE_VIEW_MAX_HEIGHT = 640;


	public ErrorDialog() {
		DialogPane dialogPane = getDialogPane();
		dialogPane.getButtonTypes().add(MoreButtonTypes.CLOSE);
		dialogPane.getStyleClass().addAll("alert", "error");

		dialogPane.expandedProperty().addListener((observable, oldValue, newVale) -> {
			Platform.runLater(() -> {
				dialogPane.requestLayout();

				Window window = dialogPane.getScene().getWindow();
				window.sizeToScene();
				window.centerOnScreen();
			});
		});
	}


	/**
	 * Sets the given exception to be shown in this dialog's expandable pane.
	 *
	 * @since 1.0
	 */
	public void setException(Throwable exception) {
		if (exception != null) {
			GridPane stackTraceContainer = new GridPane();

			TextArea stackTraceView = new TextArea();
			GridPane.setHgrow(stackTraceView, ALWAYS);
			GridPane.setVgrow(stackTraceView, ALWAYS);
			stackTraceView.setEditable(false);
			stackTraceView.setMaxHeight(STACK_TRACE_VIEW_MAX_HEIGHT);
			stackTraceView.setText(Exceptions.getStackTrace(exception));
			stackTraceContainer.add(stackTraceView, 0, 0);

			DialogPane dialogPane = getDialogPane();
			dialogPane.setExpandableContent(stackTraceContainer);
			dialogPane.setExpanded(false);
		}
	}

}
