/*
 * Copyright (c) 2015-2017 Petr Zelenka <petr.zelenka@sellcom.org>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sellcom.javafx.stage;

import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.Stage;

/**
 * Confirmation (yes/no/cancel) dialog.
 *
 * @since 1.0
 */
public class CancellableConfirmationDialog extends Dialog<Boolean> {

	/**
	 * Creates a dialog.
	 *
	 * @since 1.0
	 */
	public CancellableConfirmationDialog(Stage owner) {
		if (owner != null) {
			initOwner(owner);
		}

		getDialogPane().getStyleClass().addAll("alert", "confirmation");

		Dialogs.registerButton(this, ButtonType.YES, true);
		Dialogs.registerButton(this, ButtonType.NO, true);
		Dialogs.registerButton(this, ButtonType.CANCEL, true);

		setResultConverter(this::onConvertResult);
	}


	private Boolean onConvertResult(ButtonType buttonType) {
		return (buttonType == ButtonType.CANCEL) ? null : (buttonType == ButtonType.YES);
	}

}
