/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.application;

import java.nio.file.Path;
import java.util.Locale;
import javafx.geometry.NodeOrientation;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;
import org.sellcom.core.i18n.Resources;
import org.sellcom.core.io.MorePaths;

public abstract class Application
extends javafx.application.Application {
    private static Application INSTANCE;
    private String appId;
    private static NodeOrientation currentOrientation;

    protected Application() {
        INSTANCE = this;
    }

    public String getAppId() {
        return this.appId;
    }

    public Path getCacheDirectory() {
        Contract.checkState((this.appId != null ? 1 : 0) != 0, (String)"Application identifier has not been set", (Object[])new Object[0]);
        return MorePaths.getUserCacheDirectory((String)this.appId);
    }

    public Path getConfigDirectory() {
        Contract.checkState((this.appId != null ? 1 : 0) != 0, (String)"Application identifier has not been set", (Object[])new Object[0]);
        return MorePaths.getUserConfigDirectory((String)this.appId);
    }

    public Path getDataDirectory() {
        Contract.checkState((this.appId != null ? 1 : 0) != 0, (String)"Application identifier has not been set", (Object[])new Object[0]);
        return MorePaths.getUserDataDirectory((String)this.appId);
    }

    public static Application getInstance() {
        return INSTANCE;
    }

    public Path getLogDirectory() {
        Contract.checkState((this.appId != null ? 1 : 0) != 0, (String)"Application identifier has not been set", (Object[])new Object[0]);
        return MorePaths.getUserLogDirectory((String)this.appId);
    }

    public NodeOrientation getNodeOrientation() {
        return currentOrientation;
    }

    public void setAppId(String appId) {
        Contract.checkArgument((!Strings.isNullOrEmpty((String)appId) ? 1 : 0) != 0, (String)"Applicaton identifier must not be null or empty", (Object[])new Object[0]);
        this.appId = appId;
    }

    private static NodeOrientation getIntrinsicOrientation() {
        Locale defaultLocale = Locale.getDefault();
        switch (defaultLocale.getScript()) {
            case "Arab": {
                return NodeOrientation.RIGHT_TO_LEFT;
            }
            case "Hebr": {
                return NodeOrientation.RIGHT_TO_LEFT;
            }
            case "Thaa": {
                return NodeOrientation.RIGHT_TO_LEFT;
            }
        }
        switch (defaultLocale.getLanguage()) {
            case "ar": {
                return NodeOrientation.RIGHT_TO_LEFT;
            }
            case "dv": {
                return NodeOrientation.RIGHT_TO_LEFT;
            }
            case "fa": {
                return NodeOrientation.RIGHT_TO_LEFT;
            }
            case "iw": {
                return NodeOrientation.RIGHT_TO_LEFT;
            }
            case "ps": {
                return NodeOrientation.RIGHT_TO_LEFT;
            }
            case "ur": {
                return NodeOrientation.RIGHT_TO_LEFT;
            }
            case "ji": {
                return NodeOrientation.RIGHT_TO_LEFT;
            }
        }
        return NodeOrientation.LEFT_TO_RIGHT;
    }

    static {
        Resources.loadResources((String)"resources/strings/javafx");
        currentOrientation = Application.getIntrinsicOrientation();
    }
}

