/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.beans.binding;

import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableBooleanValue;
import org.sellcom.core.Contract;

public class MoreBindings {
    private MoreBindings() {
    }

    public static BooleanBinding and(ObservableBooleanValue firstValue, ObservableBooleanValue secondValue, ObservableBooleanValue ... otherValues) {
        Contract.checkArgument((firstValue != null ? 1 : 0) != 0, (String)"First value must not be null", (Object[])new Object[0]);
        Contract.checkArgument((secondValue != null ? 1 : 0) != 0, (String)"Second value must not be null", (Object[])new Object[0]);
        BooleanBinding result = Bindings.and((ObservableBooleanValue)firstValue, (ObservableBooleanValue)secondValue);
        if (otherValues != null) {
            for (ObservableBooleanValue currentValue : otherValues) {
                result = Bindings.and((ObservableBooleanValue)result, (ObservableBooleanValue)currentValue);
            }
        }
        return result;
    }

    public static BooleanBinding or(ObservableBooleanValue firstValue, ObservableBooleanValue secondValue, ObservableBooleanValue ... otherValues) {
        Contract.checkArgument((firstValue != null ? 1 : 0) != 0, (String)"First value must not be null", (Object[])new Object[0]);
        Contract.checkArgument((secondValue != null ? 1 : 0) != 0, (String)"Second value must not be null", (Object[])new Object[0]);
        BooleanBinding result = Bindings.or((ObservableBooleanValue)firstValue, (ObservableBooleanValue)secondValue);
        if (otherValues != null) {
            for (ObservableBooleanValue currentValue : otherValues) {
                result = Bindings.or((ObservableBooleanValue)result, (ObservableBooleanValue)currentValue);
            }
        }
        return result;
    }
}

