/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.collection;

import java.util.EnumSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import org.sellcom.core.Contract;

public class ObservableEnumSet {
    private ObservableEnumSet() {
    }

    public static <E extends Enum<E>> ObservableSet<E> allOf(Class<E> elementType) {
        Contract.checkArgument((elementType != null ? 1 : 0) != 0, (String)"Element type must not be null", (Object[])new Object[0]);
        return FXCollections.observableSet(EnumSet.allOf(elementType));
    }

    public static <E extends Enum<E>> ObservableSet<E> complementOf(EnumSet<E> enumSet) {
        Contract.checkArgument((enumSet != null ? 1 : 0) != 0, (String)"Enum set must not be null", (Object[])new Object[0]);
        return FXCollections.observableSet(EnumSet.complementOf(enumSet));
    }

    public static <E extends Enum<E>> ObservableSet<E> noneOf(Class<E> elementType) {
        Contract.checkArgument((elementType != null ? 1 : 0) != 0, (String)"Element type must not be null", (Object[])new Object[0]);
        return FXCollections.observableSet(EnumSet.noneOf(elementType));
    }

    @SafeVarargs
    public static <E extends Enum<E>> ObservableSet<E> of(E firstElement, E ... otherElements) {
        Contract.checkArgument((firstElement != null ? 1 : 0) != 0, (String)"First element set must not be null", (Object[])new Object[0]);
        return FXCollections.observableSet(EnumSet.of(firstElement, otherElements));
    }

    public static <E extends Enum<E>> ObservableSet<E> range(E firstElement, E lastElement) {
        Contract.checkArgument((firstElement != null ? 1 : 0) != 0, (String)"First element set must not be null", (Object[])new Object[0]);
        Contract.checkArgument((lastElement != null ? 1 : 0) != 0, (String)"Last element set must not be null", (Object[])new Object[0]);
        return FXCollections.observableSet(EnumSet.range(firstElement, lastElement));
    }
}

