/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.concurrent.Task;
import org.sellcom.core.Contract;

public class Tasks {
    private static final int SCHEDULED_TASK_THREAD_PRIORITY = 3;
    private static final int SIMPLE_TASK_THREAD_PRIORITY = 5;
    private static final ScheduledExecutorService scheduledTaskExecutor = Executors.newSingleThreadScheduledExecutor(Tasks::createScheduledTaskThread);
    private static final AtomicInteger scheduledTaskThreadCounter = new AtomicInteger(0);
    private static final ExecutorService simpleTaskExecutor = Executors.newCachedThreadPool(Tasks::createSimpleTaskThread);
    private static final AtomicInteger simpleTaskThreadCounter = new AtomicInteger(0);

    private Tasks() {
    }

    public static <T> Future<T> schedule(Task<T> task, long delay, TimeUnit unit) {
        Contract.checkArgument((task != null ? 1 : 0) != 0, (String)"Task must not be null", (Object[])new Object[0]);
        Contract.checkArgument((delay >= 0L ? 1 : 0) != 0, (String)"Delay must not be negative", (Object[])new Object[0]);
        Contract.checkArgument((unit != null ? 1 : 0) != 0, (String)"Time unit must not be null", (Object[])new Object[0]);
        scheduledTaskExecutor.schedule((Runnable)task, delay, unit);
        return task;
    }

    public static <T> Future<T> scheduleAtFixedRate(Task<T> task, long initialDelay, long period, TimeUnit unit) {
        Contract.checkArgument((task != null ? 1 : 0) != 0, (String)"Task must not be null", (Object[])new Object[0]);
        Contract.checkArgument((initialDelay >= 0L ? 1 : 0) != 0, (String)"Initial delay must not be negative", (Object[])new Object[0]);
        Contract.checkArgument((period >= 0L ? 1 : 0) != 0, (String)"Period must not be negative", (Object[])new Object[0]);
        Contract.checkArgument((unit != null ? 1 : 0) != 0, (String)"Time unit must not be null", (Object[])new Object[0]);
        scheduledTaskExecutor.scheduleAtFixedRate((Runnable)task, initialDelay, period, unit);
        return task;
    }

    public static <T> Future<T> scheduleWithFixedDelay(Task<T> task, long initialDelay, long delay, TimeUnit unit) {
        Contract.checkArgument((task != null ? 1 : 0) != 0, (String)"Task must not be null", (Object[])new Object[0]);
        Contract.checkArgument((initialDelay >= 0L ? 1 : 0) != 0, (String)"Initial delay must not be negative", (Object[])new Object[0]);
        Contract.checkArgument((delay >= 0L ? 1 : 0) != 0, (String)"Delay must not be negative", (Object[])new Object[0]);
        Contract.checkArgument((unit != null ? 1 : 0) != 0, (String)"Time unit must not be null", (Object[])new Object[0]);
        scheduledTaskExecutor.scheduleWithFixedDelay((Runnable)task, initialDelay, delay, unit);
        return task;
    }

    public static <T> Future<T> submit(Task<T> task) {
        Contract.checkArgument((task != null ? 1 : 0) != 0, (String)"Task must not be null", (Object[])new Object[0]);
        simpleTaskExecutor.submit((Runnable)task);
        return task;
    }

    private static Thread createScheduledTaskThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.setName("ScheduledBackgroundTaskThread-" + scheduledTaskThreadCounter.incrementAndGet());
        thread.setPriority(3);
        return thread;
    }

    private static Thread createSimpleTaskThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.setName("SimpleBackgroundTaskThread-" + simpleTaskThreadCounter.incrementAndGet());
        thread.setPriority(5);
        return thread;
    }
}

