/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.scene.control;

import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;
import org.sellcom.javafx.scene.input.KeyEvents;

public final class DoubleSpinner
extends Spinner<Double> {
    private final double defaultValue;
    private final SpinnerValueFactory.DoubleSpinnerValueFactory valueFactory;

    public DoubleSpinner() {
        this(-1.7976931348623157E308, Double.MAX_VALUE, 0.0, 1.0);
    }

    public DoubleSpinner(double min, double max) {
        this(min, max, 0.0, 1.0);
    }

    public DoubleSpinner(double min, double max, double initialValue) {
        this(min, max, initialValue, 1.0);
    }

    public DoubleSpinner(double min, double max, double initialValue, double stepSize) {
        Contract.checkArgument((max >= min ? 1 : 0) != 0, (String)"Maximum must be greater or equal to minimum: {0} < {1}", (Object[])new Object[]{max, min});
        Contract.checkArgument((initialValue >= min ? 1 : 0) != 0, (String)"Initial value must be greater or equal to minimum: {0} < {1}", (Object[])new Object[]{initialValue, min});
        Contract.checkArgument((initialValue <= max ? 1 : 0) != 0, (String)"Initial value must be less or equal to maximum: {0} > {1}", (Object[])new Object[]{initialValue, max});
        Contract.checkArgument((stepSize > 0.0 ? 1 : 0) != 0, (String)"Step size must be positive: {0}", (Object[])new Object[]{stepSize});
        this.defaultValue = initialValue;
        this.valueFactory = new SpinnerValueFactory.DoubleSpinnerValueFactory(min, max, initialValue, stepSize);
        this.getEditor().focusedProperty().addListener(this::selectAllOnFocusGained);
        this.getEditor().setOnKeyPressed(this::handleKeyPressed);
        this.setEditable(true);
        this.setValueFactory((SpinnerValueFactory)this.valueFactory);
    }

    public double getMax() {
        return this.valueFactory.getMax();
    }

    public double getMin() {
        return this.valueFactory.getMin();
    }

    public double getStepSize() {
        return this.valueFactory.getAmountToStepBy();
    }

    public boolean isWrapAround() {
        return this.valueFactory.isWrapAround();
    }

    public DoubleProperty maxProperty() {
        return this.valueFactory.maxProperty();
    }

    public DoubleProperty minProperty() {
        return this.valueFactory.minProperty();
    }

    public void setMax(double max) {
        Contract.checkArgument((max >= this.getMin() ? 1 : 0) != 0, (String)"Maximum must be greater or equal to minimum: {0} < {1}", (Object[])new Object[]{max, this.getMin()});
        this.valueFactory.setMax(max);
    }

    public void setMin(double min) {
        Contract.checkArgument((min <= this.getMax() ? 1 : 0) != 0, (String)"Minimum must be less or equal to maximum: {0} > {1}", (Object[])new Object[]{min, this.getMax()});
        this.valueFactory.setMin(min);
    }

    public void setStepSize(double stepSize) {
        Contract.checkArgument((stepSize > 0.0 ? 1 : 0) != 0, (String)"Step size must be positive: {0}", (Object[])new Object[]{stepSize});
        this.valueFactory.setAmountToStepBy(stepSize);
    }

    public void setValue(double value) {
        Contract.checkArgument((value >= this.getMin() ? 1 : 0) != 0, (String)"Value must be greater or equal to minimum: {0} < {1}", (Object[])new Object[]{value, this.getMin()});
        Contract.checkArgument((value <= this.getMax() ? 1 : 0) != 0, (String)"Value must be less or equal to maximum: {0} > {1}", (Object[])new Object[]{value, this.getMax()});
        this.valueFactory.setValue((Object)value);
    }

    public void setWrapAround(boolean wrapAround) {
        this.valueFactory.setWrapAround(wrapAround);
    }

    public DoubleProperty stepSizeProperty() {
        return this.valueFactory.amountToStepByProperty();
    }

    public BooleanProperty wrapAroundProperty() {
        return this.valueFactory.wrapAroundProperty();
    }

    public final ObjectProperty<Double> writableValueProperty() {
        return this.valueFactory.valueProperty();
    }

    private void handleKeyPressed(KeyEvent event) {
        if (KeyEvents.is(event, KeyCode.DOWN)) {
            event.consume();
            this.valueFactory.decrement(1);
            return;
        }
        if (KeyEvents.is(event, KeyCode.UP)) {
            event.consume();
            this.valueFactory.increment(1);
            return;
        }
        TextField editor = this.getEditor();
        if (Strings.isNullOrEmpty((String)editor.getText())) {
            editor.setText(this.valueFactory.getConverter().toString((Object)this.defaultValue));
            editor.selectAll();
        }
    }

    private void selectAllOnFocusGained(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue()) {
            Platform.runLater(() -> this.getEditor().selectAll());
        }
    }
}

