/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.scene.control;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.KeyCombination;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;

public class Menus {
    private Menus() {
    }

    public static Menu createMenu(String text) {
        Contract.checkArgument((!Strings.isNullOrEmpty((String)text) ? 1 : 0) != 0, (String)"Text must not be null or empty", (Object[])new Object[0]);
        return new Menu(text);
    }

    public static MenuItem createMenuItem(String text, EventHandler<ActionEvent> actionHandler) {
        Contract.checkArgument((!Strings.isNullOrEmpty((String)text) ? 1 : 0) != 0, (String)"Text must not be null or empty", (Object[])new Object[0]);
        Contract.checkArgument((actionHandler != null ? 1 : 0) != 0, (String)"Action handler must not be null", (Object[])new Object[0]);
        MenuItem menuItem = new MenuItem(text);
        menuItem.setOnAction(actionHandler);
        return menuItem;
    }

    public static MenuItem createMenuItem(String text, String accelerator, EventHandler<ActionEvent> actionHandler) {
        Contract.checkArgument((!Strings.isNullOrEmpty((String)text) ? 1 : 0) != 0, (String)"Text must not be null or empty", (Object[])new Object[0]);
        Contract.checkArgument((!Strings.isNullOrEmpty((String)accelerator) ? 1 : 0) != 0, (String)"Accelerator must not be null or empty", (Object[])new Object[0]);
        Contract.checkArgument((actionHandler != null ? 1 : 0) != 0, (String)"Action handler must not be null", (Object[])new Object[0]);
        MenuItem menuItem = new MenuItem(text);
        menuItem.setAccelerator(KeyCombination.keyCombination((String)accelerator));
        menuItem.setOnAction(actionHandler);
        return menuItem;
    }

    public static SeparatorMenuItem createSeparator() {
        return new SeparatorMenuItem();
    }
}

