/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.scene.control;

import javafx.geometry.Pos;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class TableCellFactories {
    private TableCellFactories() {
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> centerAlignedCellFactory() {
        return column -> new CenterAlignedTableCell();
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> rightAlignedCellFactory() {
        return column -> new RightAlignedTableCell();
    }

    private static class RightAlignedTableCell<S, T>
    extends TableCell<S, T> {
        private RightAlignedTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            this.setAlignment(Pos.CENTER_RIGHT);
            if (item != null) {
                this.setText(item.toString());
            }
        }
    }

    private static class CenterAlignedTableCell<S, T>
    extends TableCell<S, T> {
        private CenterAlignedTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            this.setAlignment(Pos.CENTER);
            if (item != null) {
                this.setText(item.toString());
            }
        }
    }
}

