/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.scene.input;

import java.util.EnumSet;
import java.util.Set;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.sellcom.core.Contract;

public class KeyEvents {
    private static final EventConsumingHandler consumingHandler = new EventConsumingHandler();

    private KeyEvents() {
    }

    public static void disableKeyPressed(Node node) {
        Contract.checkArgument((node != null ? 1 : 0) != 0, (String)"Node must not be null", (Object[])new Object[0]);
        node.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)consumingHandler);
    }

    public static void disableKeyReleased(Node node) {
        Contract.checkArgument((node != null ? 1 : 0) != 0, (String)"Node must not be null", (Object[])new Object[0]);
        node.addEventFilter(KeyEvent.KEY_RELEASED, (EventHandler)consumingHandler);
    }

    public static void disableKeyTyped(Node node) {
        Contract.checkArgument((node != null ? 1 : 0) != 0, (String)"Node must not be null", (Object[])new Object[0]);
        node.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)consumingHandler);
    }

    public static void enableKeyPressed(Node node) {
        Contract.checkArgument((node != null ? 1 : 0) != 0, (String)"Node must not be null", (Object[])new Object[0]);
        node.removeEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)consumingHandler);
    }

    public static void enableKeyReleased(Node node) {
        Contract.checkArgument((node != null ? 1 : 0) != 0, (String)"Node must not be null", (Object[])new Object[0]);
        node.removeEventFilter(KeyEvent.KEY_RELEASED, (EventHandler)consumingHandler);
    }

    public static void enableKeyTyped(Node node) {
        Contract.checkArgument((node != null ? 1 : 0) != 0, (String)"Node must not be null", (Object[])new Object[0]);
        node.removeEventFilter(KeyEvent.KEY_TYPED, (EventHandler)consumingHandler);
    }

    public static boolean is(KeyEvent event, KeyCode mainKey) {
        return KeyEvents.is(event, mainKey, EnumSet.noneOf(KeyCode.class));
    }

    public static boolean is(KeyEvent event, KeyCode mainKey, Set<KeyCode> modifierKeys) {
        Contract.checkArgument((event != null ? 1 : 0) != 0, (String)"Event must not be null", (Object[])new Object[0]);
        Contract.checkArgument((mainKey != null ? 1 : 0) != 0, (String)"Main key must not be null", (Object[])new Object[0]);
        Contract.checkArgument((modifierKeys != null ? 1 : 0) != 0, (String)"Modifier keys must not be null", (Object[])new Object[0]);
        if (event.getCode() != mainKey) {
            return false;
        }
        if (modifierKeys.contains(KeyCode.ALT) && !event.isAltDown()) {
            return false;
        }
        if (modifierKeys.contains(KeyCode.CONTROL) && !event.isControlDown()) {
            return false;
        }
        if (modifierKeys.contains(KeyCode.META) && !event.isMetaDown()) {
            return false;
        }
        if (modifierKeys.contains(KeyCode.SHIFT) && !event.isShiftDown()) {
            return false;
        }
        return !modifierKeys.contains(KeyCode.SHORTCUT) || event.isShortcutDown();
    }

    private static class EventConsumingHandler
    implements EventHandler<KeyEvent> {
        private EventConsumingHandler() {
        }

        public void handle(KeyEvent event) {
            event.consume();
        }
    }
}

