/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.scene.input;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.sellcom.core.Contract;

public class MouseEvents {
    private static final EventConsumingHandler consumingHandler = new EventConsumingHandler();

    private MouseEvents() {
    }

    public static void disableMouseClicked(Node node) {
        Contract.checkArgument((node != null ? 1 : 0) != 0, (String)"Node must not be null", (Object[])new Object[0]);
        node.addEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)consumingHandler);
    }

    public static void disableMousePressed(Node node) {
        Contract.checkArgument((node != null ? 1 : 0) != 0, (String)"Node must not be null", (Object[])new Object[0]);
        node.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)consumingHandler);
    }

    public static void disableMouseReleased(Node node) {
        Contract.checkArgument((node != null ? 1 : 0) != 0, (String)"Node must not be null", (Object[])new Object[0]);
        node.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)consumingHandler);
    }

    public static void enableMouseClicked(Node node) {
        Contract.checkArgument((node != null ? 1 : 0) != 0, (String)"Node must not be null", (Object[])new Object[0]);
        node.removeEventFilter(MouseEvent.MOUSE_CLICKED, (EventHandler)consumingHandler);
    }

    public static void enableMousePressed(Node node) {
        Contract.checkArgument((node != null ? 1 : 0) != 0, (String)"Node must not be null", (Object[])new Object[0]);
        node.removeEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)consumingHandler);
    }

    public static void enableMouseReleased(Node node) {
        Contract.checkArgument((node != null ? 1 : 0) != 0, (String)"Node must not be null", (Object[])new Object[0]);
        node.removeEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)consumingHandler);
    }

    private static class EventConsumingHandler
    implements EventHandler<MouseEvent> {
        private EventConsumingHandler() {
        }

        public void handle(MouseEvent event) {
            event.consume();
        }
    }
}

