/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.stage;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import org.sellcom.core.Contract;

public class Dialogs {
    private Dialogs() {
    }

    public static void registerButton(Dialog<?> dialog, ButtonType type, boolean shallCloseDialog) {
        Contract.checkArgument((dialog != null ? 1 : 0) != 0, (String)"Dialog must not be null", (Object[])new Object[0]);
        Contract.checkArgument((type != null ? 1 : 0) != 0, (String)"Button type must not be null", (Object[])new Object[0]);
        DialogPane dialogPane = dialog.getDialogPane();
        dialogPane.getButtonTypes().add((Object)type);
        if (!shallCloseDialog) {
            Button button = (Button)dialogPane.lookupButton(type);
            button.addEventFilter(ActionEvent.ACTION, event -> {
                EventHandler handler = button.getOnAction();
                if (handler != null) {
                    handler.handle(event);
                }
                event.consume();
            });
        }
    }
}

