/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.stage;

import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.sellcom.core.Exceptions;
import org.sellcom.javafx.scene.control.MoreButtonTypes;

public class ErrorDialog
extends Dialog<Void> {
    private static final int STACK_TRACE_VIEW_MAX_HEIGHT = 640;

    public ErrorDialog(Stage owner) {
        if (owner != null) {
            this.initOwner((Window)owner);
        }
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.getButtonTypes().add((Object)MoreButtonTypes.CLOSE);
        dialogPane.getStyleClass().addAll((Object[])new String[]{"alert", "error"});
        dialogPane.expandedProperty().addListener((observable, oldValue, newVale) -> Platform.runLater(() -> {
            dialogPane.requestLayout();
            Window window = dialogPane.getScene().getWindow();
            window.sizeToScene();
            window.centerOnScreen();
        }));
    }

    public void setException(Throwable exception) {
        if (exception != null) {
            GridPane stackTraceContainer = new GridPane();
            TextArea stackTraceView = new TextArea();
            GridPane.setHgrow((Node)stackTraceView, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)stackTraceView, (Priority)Priority.ALWAYS);
            stackTraceView.setEditable(false);
            stackTraceView.setMaxHeight(640.0);
            stackTraceView.setText(Exceptions.getStackTrace((Throwable)exception));
            stackTraceContainer.add((Node)stackTraceView, 0, 0);
            DialogPane dialogPane = this.getDialogPane();
            dialogPane.setExpandableContent((Node)stackTraceContainer);
            dialogPane.setExpanded(false);
        }
    }
}

