/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.stage;

import java.io.IOException;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Hyperlink;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;
import org.sellcom.core.i18n.Resources;
import org.sellcom.javafx.stage.FxmlLoaderException;

public abstract class FxmlDialog<R>
extends Dialog<R> {
    private final DialogPane dialogPane;
    private final Object controller;

    protected FxmlDialog(String resourceName) {
        Contract.checkArgument((!Strings.isNullOrEmpty((String)resourceName) ? 1 : 0) != 0, (String)"Resource name must not be null or empty", (Object[])new Object[0]);
        this.dialogPane = new LocalizedDialogPane();
        this.setDialogPane(this.dialogPane);
        try {
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(resourceName));
            this.dialogPane.setContent((Node)loader.load());
            this.dialogPane.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/resources/styles/validation.css").toExternalForm());
            this.controller = loader.getController();
        }
        catch (IOException e) {
            throw new FxmlLoaderException(String.format("Error loading FXML resource: %s", resourceName), e);
        }
    }

    public <T> T getController(Class<T> controllerClass) {
        Contract.checkArgument((controllerClass != null ? 1 : 0) != 0, (String)"Controller class must not be null", (Object[])new Object[0]);
        return (T)this.controller;
    }

    public void setButtonTypes(ButtonType firstButtonType, ButtonType ... nextButtonTypes) {
        Contract.checkArgument((firstButtonType != null ? 1 : 0) != 0, (String)"First button type must not be null", (Object[])new Object[0]);
        this.dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{firstButtonType});
        this.dialogPane.getButtonTypes().addAll((Object[])nextButtonTypes);
    }

    static class LocalizedDialogPane
    extends DialogPane {
        LocalizedDialogPane() {
        }

        protected Node createDetailsButton() {
            Hyperlink detailsButton = new Hyperlink();
            InvalidationListener expandedAndCollapsedListener = observable -> {
                if (this.isExpanded()) {
                    detailsButton.getStyleClass().setAll((Object[])new String[]{"details-button", "less"});
                    detailsButton.setText(Resources.getString((String)"dialog.detail.showLess", (Object[])new Object[0]));
                } else {
                    detailsButton.getStyleClass().setAll((Object[])new String[]{"details-button", "more"});
                    detailsButton.setText(Resources.getString((String)"dialog.detail.showMore", (Object[])new Object[0]));
                }
            };
            expandedAndCollapsedListener.invalidated(null);
            this.expandedProperty().addListener(expandedAndCollapsedListener);
            detailsButton.setOnAction(event -> this.setExpanded(!this.isExpanded()));
            return detailsButton;
        }
    }
}

