/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.stage;

import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;
import org.sellcom.javafx.stage.FxmlLoaderException;

public abstract class FxmlStage
extends Stage {
    private final Object controller;

    protected FxmlStage(String resourceName) {
        Contract.checkArgument((!Strings.isNullOrEmpty((String)resourceName) ? 1 : 0) != 0, (String)"Resource name must not be null or empty", (Object[])new Object[0]);
        try {
            FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource(resourceName));
            Scene scene = new Scene((Parent)loader.load());
            scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/resources/styles/validation.css").toExternalForm());
            this.setScene(scene);
            this.controller = loader.getController();
        }
        catch (IOException e) {
            throw new FxmlLoaderException(String.format("Error loading FXML resource: %s", resourceName), e);
        }
    }

    public <T> T getController(Class<T> controllerClass) {
        Contract.checkArgument((controllerClass != null ? 1 : 0) != 0, (String)"Controller class must not be null", (Object[])new Object[0]);
        return (T)this.controller;
    }
}

