/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.stage;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.sellcom.core.Contract;
import org.sellcom.core.Strings;
import org.sellcom.core.io.MorePaths;

public class PathChooser {
    private final FileChooser fileChooser = new FileChooser();
    private final ObjectProperty<Path> initialDirectoryProperty = new SimpleObjectProperty();

    public PathChooser() {
        this.setupBindings();
    }

    public ObservableList<FileChooser.ExtensionFilter> getExtensionFilters() {
        return this.fileChooser.getExtensionFilters();
    }

    public Path getInitialDirectory() {
        return (Path)this.initialDirectoryProperty.get();
    }

    public String getInitialFileName() {
        return this.fileChooser.getInitialFileName();
    }

    public FileChooser.ExtensionFilter getSelectedExtensionFilter() {
        return this.fileChooser.getSelectedExtensionFilter();
    }

    public String getTitle() {
        return this.fileChooser.getTitle();
    }

    public ObjectProperty<Path> initialDirectoryProperty() {
        return this.initialDirectoryProperty;
    }

    public ObjectProperty<String> initialFileNameProperty() {
        return this.fileChooser.initialFileNameProperty();
    }

    public ObjectProperty<FileChooser.ExtensionFilter> selectedExtensionFilterProperty() {
        return this.fileChooser.selectedExtensionFilterProperty();
    }

    public void setInitialDirectory(Path directory) {
        Contract.checkArgument((directory != null ? 1 : 0) != 0, (String)"Directory must not be null", (Object[])new Object[0]);
        this.initialDirectoryProperty.set((Object)directory);
    }

    public void setInitialFileName(String fileName) {
        Contract.checkArgument((!Strings.isNullOrEmpty((String)fileName) ? 1 : 0) != 0, (String)"File name must not be null or empty", (Object[])new Object[0]);
        this.fileChooser.setInitialFileName(fileName);
    }

    public void setSelectedExtensionFilter(FileChooser.ExtensionFilter extensionFilter) {
        Contract.checkArgument((extensionFilter != null ? 1 : 0) != 0, (String)"Extension filter must not be null", (Object[])new Object[0]);
        this.fileChooser.setSelectedExtensionFilter(extensionFilter);
    }

    public void setTitle(String title) {
        Contract.checkArgument((!Strings.isNullOrEmpty((String)title) ? 1 : 0) != 0, (String)"Title must not be null or empty", (Object[])new Object[0]);
        this.fileChooser.setTitle(title);
    }

    public Optional<Path> showOpenDialog(Window ownerWindow) {
        return Optional.ofNullable(this.fileChooser.showOpenDialog(ownerWindow)).map(File::toPath);
    }

    public List<Path> showOpenMultipleDialog(Window ownerWindow) {
        return this.fileChooser.showOpenMultipleDialog(ownerWindow).stream().map(File::toPath).collect(Collectors.toList());
    }

    public Optional<Path> showSaveDialog(Window ownerWindow) {
        List possibleExtensions;
        Optional<Path> selectedFile = Optional.ofNullable(this.fileChooser.showSaveDialog(ownerWindow)).map(File::toPath);
        if (selectedFile.isPresent() && !(possibleExtensions = this.getSelectedExtensionFilter().getExtensions().stream().filter(extension -> !Strings.endsWith((String)extension, (String)".*", (boolean)false)).collect(Collectors.toList())).isEmpty()) {
            String actualExtension = MorePaths.getFileExtension((Path)selectedFile.get());
            Optional<String> expectedExtension = possibleExtensions.stream().map(extension -> extension.replace("*.", "")).filter(extension -> extension.equalsIgnoreCase(actualExtension)).findFirst();
            if (!expectedExtension.isPresent()) {
                String pathWithoutExtension = selectedFile.get().toString();
                String extension2 = ((String)possibleExtensions.get(0)).replace("*.", "");
                selectedFile = Optional.of(Paths.get(pathWithoutExtension + "." + extension2, new String[0]));
            }
        }
        return selectedFile;
    }

    public StringProperty titleProperty() {
        return this.fileChooser.titleProperty();
    }

    private void setupBindings() {
        this.initialDirectoryProperty.addListener((observable, oldValue, newValue) -> {
            if (Files.isDirectory(newValue, new LinkOption[0])) {
                this.fileChooser.setInitialDirectory(newValue.toAbsolutePath().toFile());
            }
        });
    }
}

