/*
 * Decompiled with CFR 0.152.
 */
package org.sellcom.javafx.stage;

import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;

public class Screens {
    private static final ReadOnlyListWrapper<Screen> additionalScreensWrapper = new ReadOnlyListWrapper(FXCollections.observableArrayList());

    private Screens() {
    }

    public static ReadOnlyListProperty<Screen> additionalScreensProperty() {
        return additionalScreensWrapper.getReadOnlyProperty();
    }

    public static ObservableList<Screen> getAdditionalScreens() {
        return FXCollections.unmodifiableObservableList(additionalScreensWrapper);
    }

    private static void updateScreens() {
        List additionalScreens = Screen.getScreens().stream().filter(screen -> !screen.equals((Object)Screen.getPrimary())).sorted((former, latter) -> {
            Rectangle2D formerBounds = former.getBounds();
            Rectangle2D latterBounds = latter.getBounds();
            int result = Double.compare(formerBounds.getMinX(), latterBounds.getMinX());
            if (result != 0) {
                return result;
            }
            result = Double.compare(formerBounds.getMinY(), latterBounds.getMinY());
            if (result != 0) {
                return result;
            }
            return 0;
        }).collect(Collectors.toList());
        additionalScreensWrapper.setAll(additionalScreens);
    }

    static {
        ObservableList allScreens = Screen.getScreens();
        allScreens.addListener(observable -> Screens.updateScreens());
        Screens.updateScreens();
    }
}

