/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.test;

import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.openrdf.OpenRDFException;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.util.ModelUtil;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.QueryResultHandler;
import org.openrdf.query.QueryResults;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.resultio.helpers.QueryResultCollector;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.helpers.ContextStatementCollector;
import org.openrdf.rio.helpers.ParseErrorCollector;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;

public class SesameTestHelper {
    private final String testOutputDir;
    private final Map<String, String> localMirrors;

    public SesameTestHelper(String testOutputDir, Map<String, String> localMirrors) {
        this.testOutputDir = testOutputDir;
        this.localMirrors = localMirrors;
        try {
            File testDir = new File(testOutputDir);
            testDir.mkdirs();
            FileUtils.cleanDirectory((File)testDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static RDFFormat detectFileFormat(String filename) {
        RDFFormat result = Rio.getParserFormatForFileName((String)filename);
        if (result == null) {
            throw new IllegalArgumentException("Unknown file format");
        }
        return result;
    }

    public InputStream openStreamForResource(String uri) throws FileNotFoundException {
        String result = uri;
        for (String remoteUri : this.localMirrors.keySet()) {
            if (!uri.startsWith(remoteUri)) continue;
            result = uri.replace(remoteUri, this.localMirrors.get(remoteUri));
        }
        File file = new File(result);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        result = SesameTestHelper.class.getClassLoader().getResource(result).getFile();
        if (result.contains(".jar!/")) {
            try {
                return new URL("jar:" + result).openStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        return new FileInputStream(result);
    }

    public String getOutputPath(String uri, String ext) {
        String result = uri;
        for (String remoteUri : this.localMirrors.keySet()) {
            if (!uri.startsWith(remoteUri)) continue;
            result = uri.replace(remoteUri, this.testOutputDir);
        }
        result = result.substring(0, result.lastIndexOf(46)) + "-out." + ext;
        return result;
    }

    public Model createModelFromFile(String filename, String baseUri) throws IOException {
        LinkedHashModel model = new LinkedHashModel();
        if (filename != null) {
            try {
                RDFParser parser = Rio.createParser((RDFFormat)SesameTestHelper.detectFileFormat(filename));
                parser.setRDFHandler((RDFHandler)new ContextStatementCollector((Collection)model, (ValueFactory)ValueFactoryImpl.getInstance(), new Resource[0]));
                ParserConfig config = parser.getParserConfig();
                config.set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
                config.addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
                config.addNonFatalError(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
                config.set(BasicParserSettings.NORMALIZE_DATATYPE_VALUES, (Object)true);
                config.addNonFatalError(BasicParserSettings.NORMALIZE_DATATYPE_VALUES);
                ParseErrorCollector errors = new ParseErrorCollector();
                parser.setParseErrorListener((ParseErrorListener)errors);
                parser.parse(this.openStreamForResource(filename), baseUri);
                for (String nextFatalError : errors.getFatalErrors()) {
                    System.err.println("Fatal parse error was ignored : " + filename + " : " + nextFatalError);
                }
                for (String nextError : errors.getErrors()) {
                    System.err.println("Parse error was ignored : " + filename + " : " + nextError);
                }
                for (String nextWarning : errors.getWarnings()) {
                    System.err.println("Parse warning was ignored : " + filename + " : " + nextWarning);
                }
            }
            catch (OpenRDFException e) {
                System.err.println("Fatal parse error caused failure : " + filename + " : " + e.getMessage());
                model = new LinkedHashModel();
            }
        }
        return model;
    }

    public <E> List<E> getTestCases(String manifestUri, String queryStr, Class<E> template) {
        SailRepository repository = new SailRepository((Sail)new MemoryStore());
        ArrayList<E> testCases = new ArrayList<E>();
        try {
            repository.initialize();
            repository.getConnection().add(this.openStreamForResource(manifestUri), manifestUri, SesameTestHelper.detectFileFormat(manifestUri), new Resource[0]);
            TupleQuery query = repository.getConnection().prepareTupleQuery(QueryLanguage.SPARQL, queryStr, manifestUri);
            TupleQueryResult queryResults = query.evaluate();
            QueryResultCollector collector = new QueryResultCollector();
            QueryResults.report((TupleQueryResult)queryResults, (QueryResultHandler)collector);
            for (BindingSet bindingSet : collector.getBindingSets()) {
                E testCase = template.newInstance();
                for (String fieldName : bindingSet.getBindingNames()) {
                    try {
                        template.getDeclaredField(fieldName).set(testCase, bindingSet.getBinding(fieldName).getValue().stringValue());
                    }
                    catch (NoSuchFieldException e) {}
                }
                testCases.add(testCase);
            }
            return testCases;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean areModelsEqual(String producedModelPath, String expectedModelPath, String baseUri) {
        try {
            Model inputModel = this.createModelFromFile(producedModelPath, baseUri);
            Model expected = this.createModelFromFile(expectedModelPath, baseUri);
            return ModelUtil.equals((Set)inputModel, (Set)expected);
        }
        catch (IOException e) {
            return false;
        }
    }

    public String diff(Model model1, Model model2) {
        StringBuilder result = new StringBuilder();
        LinkedHashModel delta = new LinkedHashModel(model1);
        delta.removeAll((Collection)model2);
        Object[] lines = new String[delta.size()];
        int i = 0;
        for (Statement s : delta) {
            lines[i++] = s.toString();
        }
        Arrays.sort(lines);
        for (Object s : lines) {
            result.append("\n").append((String)s);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean askModel(String resultFilePath, String queryStr, String inputUri, boolean expectedResult) {
        SailRepository repository = new SailRepository((Sail)new MemoryStore());
        RepositoryConnection conn = null;
        try {
            repository.initialize();
            conn = repository.getConnection();
            conn.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
            conn.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_LANGUAGE_TAGS);
            conn.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_RELATIVE_URIS);
            conn.add(this.openStreamForResource(resultFilePath), inputUri, SesameTestHelper.detectFileFormat(resultFilePath), new Resource[0]);
            BooleanQuery query = repository.getConnection().prepareBooleanQuery(QueryLanguage.SPARQL, queryStr, inputUri);
            boolean result = query.evaluate();
            if (result != expectedResult) {
                System.err.println("Test failed for: " + inputUri);
                System.err.println("Expected [" + expectedResult + "] but found [" + result + "]");
                System.err.println("Query: " + queryStr);
                System.err.println("Statements");
                System.err.println("===============================");
                for (Statement nextStatement : Iterations.asSet((Iteration)conn.getStatements(null, null, null, true, new Resource[0]))) {
                    System.err.println(nextStatement);
                }
                System.err.println("===============================");
            }
            boolean i$ = result;
            return i$;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = !expectedResult;
            return bl;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

