/**
 * Copyright 2012-2013 the Semargl contributors. See AUTHORS for more details.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.semarglproject.vocab;

/**
 * Defines JSON-LD keywords
 */
public final class JsonLd {

    public static final String BASE_KEY = "@base";
    public static final String CONTEXT_KEY = "@context";
    public static final String GRAPH_KEY = "@graph";
    public static final String LIST_KEY = "@list";
    public static final String SET_KEY = "@set";
    public static final String ID_KEY = "@id";
    public static final String TYPE_KEY = "@type";
    public static final String CONTAINER_KEY = "@container";
    public static final String REVERSE_KEY = "@reverse";
    public static final String LANGUAGE_KEY = "@language";
    public static final String VALUE_KEY = "@value";
    public static final String VOCAB_KEY = "@vocab";

    // TODO: remove from public
    public static final String CONTAINER_LIST_KEY = "@container@list";
    public static final String CONTAINER_SET_KEY = "@container@set";
    public static final String CONTAINER_INDEX_KEY = "@container@index";
    public static final String CONTAINER_LANGUAGE_KEY = "@container@language";
    public static final String NULL = "@@null";
    public static final String DOC_IRI = "@@dociri";

    private JsonLd() {
    }

}
