/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.jsonld;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import org.semarglproject.jsonld.DocumentContext;
import org.semarglproject.ri.MalformedCurieException;
import org.semarglproject.ri.MalformedIriException;
import org.semarglproject.ri.RIUtils;
import org.semarglproject.sink.QuadSink;

final class EvalContext {
    static final int ID_DECLARED = 1;
    static final int CONTEXT_DECLARED = 2;
    static final int PARENT_SAFE = 4;
    static final int SAFE_TO_SINK_TRIPLES = 7;
    String base;
    String graph;
    String subject;
    String predicate;
    String vocab;
    String lang;
    String objectLit;
    String objectLitDt;
    String listTail;
    boolean parsingArray;
    String containerType;
    boolean nullified;
    boolean hasProps;
    boolean hasNonGraphContextProps;
    boolean reversed;
    boolean wrapped;
    boolean index;
    EvalContext parent;
    private int state;
    private final QuadSink sink;
    private final DocumentContext documentContext;
    private final Map<String, String> iriMappings = new TreeMap<String, String>();
    private final Map<String, String> dtMappings = new TreeMap<String, String>();
    private final Map<String, String> langMappings = new TreeMap<String, String>();
    private final Collection<EvalContext> children = new ArrayList<EvalContext>();
    private final Queue<String> nonLiteralQueue = new LinkedList<String>();
    private final Queue<String> plainLiteralQueue = new LinkedList<String>();
    private final Queue<String> typedLiteralQueue = new LinkedList<String>();

    private EvalContext(DocumentContext documentContext, QuadSink sink, EvalContext parent) {
        this.sink = sink;
        this.parent = parent;
        this.documentContext = documentContext;
    }

    static EvalContext createInitialContext(DocumentContext documentContext, QuadSink sink) {
        EvalContext initialContext = new EvalContext(documentContext, sink, null);
        initialContext.base = "@@dociri";
        initialContext.subject = ".";
        initialContext.state = 7;
        return initialContext;
    }

    EvalContext initChildContext(String graph) {
        EvalContext child = new EvalContext(this.documentContext, this.sink, this);
        child.lang = this.lang;
        child.subject = this.documentContext.createBnode(false);
        child.graph = this.graph;
        child.vocab = this.vocab;
        this.children.add(child);
        if (graph != null) {
            child.graph = graph;
        }
        return child;
    }

    void nullify() {
        this.iriMappings.clear();
        this.dtMappings.clear();
        this.langMappings.clear();
        this.lang = null;
        this.nullified = true;
        this.base = this.documentContext.iri;
    }

    boolean isPredicateKeyword() {
        return this.predicate.charAt(0) == '@';
    }

    void defineIriMappingForPredicate(String value) {
        if (this.vocab != null && value != null && value.indexOf(58) == -1) {
            value = this.vocab + value;
        }
        this.iriMappings.put(this.predicate, value);
        if (!this.dtMappings.containsKey(this.predicate)) {
            this.dtMappings.put(this.predicate, null);
        }
        if (!this.langMappings.containsKey(this.predicate)) {
            this.langMappings.put(this.predicate, null);
        }
    }

    void defineDtMappingForPredicate(String value) {
        this.dtMappings.put(this.predicate, value);
    }

    String getDtMapping(String value) {
        if (this.dtMappings.containsKey(value)) {
            return this.dtMappings.get(value);
        }
        if (!this.nullified && this.parent != null) {
            return this.parent.getDtMapping(value);
        }
        return null;
    }

    public void defineLangMappingForPredicate(String value) {
        this.langMappings.put(this.predicate, value);
    }

    private String getLangMapping(String value) {
        if (this.langMappings.containsKey(value)) {
            return this.langMappings.get(value);
        }
        if (!this.nullified && this.parent != null) {
            return this.parent.getLangMapping(value);
        }
        return null;
    }

    private String getBase() {
        if (this.base != null) {
            return this.base;
        }
        if (!this.nullified && this.parent != null) {
            return this.parent.getBase();
        }
        return null;
    }

    void updateState(int state) {
        this.state |= state;
        if (this.state == 7) {
            for (EvalContext child : this.children.toArray(new EvalContext[this.children.size()])) {
                child.updateState(4);
            }
            if (this.children.isEmpty()) {
                this.sinkUnsafeTriples();
            }
        }
    }

    private void sinkUnsafeTriples() {
        try {
            if (!this.subject.startsWith("_:")) {
                this.subject = this.resolveCurieOrIri(this.subject, false);
            }
            this.graph = this.resolve(this.graph, false, false);
        }
        catch (MalformedIriException e) {
            this.nonLiteralQueue.clear();
            this.plainLiteralQueue.clear();
            this.typedLiteralQueue.clear();
        }
        while (!this.nonLiteralQueue.isEmpty()) {
            this.addNonLiteralUnsafe(this.nonLiteralQueue.poll(), this.nonLiteralQueue.poll(), this.nonLiteralQueue.poll());
        }
        while (!this.plainLiteralQueue.isEmpty()) {
            this.addPlainLiteralUnsafe(this.plainLiteralQueue.poll(), this.plainLiteralQueue.poll(), this.plainLiteralQueue.poll());
        }
        while (!this.typedLiteralQueue.isEmpty()) {
            this.addTypedLiteralUnsafe(this.typedLiteralQueue.poll(), this.typedLiteralQueue.poll(), this.typedLiteralQueue.poll());
        }
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
    }

    public void addListFirst(String object) {
        if (this.listTail.equals(this.subject)) {
            if (this.state == 7) {
                this.addPlainLiteralUnsafe("http://www.w3.org/1999/02/22-rdf-syntax-ns#first", object, this.lang);
            } else {
                this.plainLiteralQueue.offer("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
                this.plainLiteralQueue.offer(object);
                this.plainLiteralQueue.offer(this.lang);
            }
        } else {
            this.sink.addPlainLiteral(this.listTail, "http://www.w3.org/1999/02/22-rdf-syntax-ns#first", object, this.lang, this.graph);
        }
    }

    public void addListFirst(String object, String dt) {
        if (this.listTail.equals(this.subject)) {
            if (this.state == 7) {
                this.addTypedLiteralUnsafe("http://www.w3.org/1999/02/22-rdf-syntax-ns#first", object, dt);
            } else {
                this.typedLiteralQueue.offer("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
                this.typedLiteralQueue.offer(object);
                this.typedLiteralQueue.offer(dt);
            }
        } else {
            this.sink.addTypedLiteral(this.listTail, "http://www.w3.org/1999/02/22-rdf-syntax-ns#first", object, dt, this.graph);
        }
    }

    public void addListRest(String object) {
        if (this.listTail.equals(this.subject)) {
            if (this.state == 7) {
                this.addNonLiteralUnsafe("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", object, null);
            } else {
                this.nonLiteralQueue.offer("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
                this.nonLiteralQueue.offer(object);
                this.nonLiteralQueue.offer(null);
            }
        } else {
            this.sink.addNonLiteral(this.listTail, "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", object, this.graph);
        }
        this.listTail = object;
    }

    public void addToSet(String object) {
        this.parent.addPlainLiteral(object, this.lang);
    }

    public void addToSet(String object, String dt) {
        this.parent.addTypedLiteral(object, dt);
    }

    void addNonLiteral(String predicate, String object, String base) {
        if (this.parent != null && predicate.equals("@set")) {
            this.parent.addNonLiteral(predicate, object, base);
        } else if (this.state == 7) {
            this.addNonLiteralUnsafe(predicate, object, base);
        } else {
            this.nonLiteralQueue.offer(predicate);
            this.nonLiteralQueue.offer(object);
            this.nonLiteralQueue.offer(base);
        }
    }

    private void addNonLiteralUnsafe(String predicate, String object, String base) {
        try {
            if (object == null) {
                return;
            }
            boolean reversed = this.reversed ^ "@reverse".equals(this.getDtMapping(predicate));
            String resolvedPredicate = this.resolve(predicate);
            String oldBase = this.base;
            if (base != null) {
                this.base = base;
            }
            object = this.resolve(object, false, resolvedPredicate.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"));
            this.base = oldBase;
            if (reversed) {
                this.sink.addNonLiteral(object, resolvedPredicate, this.subject, this.graph);
            } else {
                this.sink.addNonLiteral(this.subject, resolvedPredicate, object, this.graph);
            }
        }
        catch (MalformedIriException e) {
            // empty catch block
        }
    }

    void addPlainLiteral(String object, String lang) {
        if (this.parent != null && this.predicate.equals("@set")) {
            this.parent.addPlainLiteral(object, lang);
        } else if (this.state == 7) {
            this.addPlainLiteralUnsafe(this.predicate, object, lang);
        } else {
            this.plainLiteralQueue.offer(this.predicate);
            this.plainLiteralQueue.offer(object);
            this.plainLiteralQueue.offer(lang);
        }
    }

    private void addPlainLiteralUnsafe(String predicate, String object, String lang) {
        try {
            boolean reversed;
            String dt = this.getDtMapping(predicate);
            if (dt != null) {
                if ("@id".equals(dt)) {
                    this.addNonLiteralUnsafe(predicate, object, null);
                    return;
                }
                if (!dt.startsWith("@")) {
                    this.addTypedLiteralUnsafe(predicate, object, dt);
                    return;
                }
            }
            String resolvedLang = lang;
            if ("@language".equals(lang)) {
                resolvedLang = this.getLangMapping(predicate);
                if ("@@null".equals(resolvedLang)) {
                    resolvedLang = null;
                } else if (resolvedLang == null) {
                    resolvedLang = this.lang;
                }
            }
            if (reversed = this.reversed ^ "@reverse".equals(this.getDtMapping(predicate))) {
                this.sink.addNonLiteral(object, this.resolve(predicate), this.subject, this.graph);
            } else {
                this.sink.addPlainLiteral(this.subject, this.resolve(predicate), object, resolvedLang, this.graph);
            }
        }
        catch (MalformedIriException e) {
            // empty catch block
        }
    }

    void addTypedLiteral(String object, String dt) {
        if (this.parent != null && this.predicate.equals("@set")) {
            this.parent.addTypedLiteral(object, dt);
        } else if (this.state == 7) {
            this.addTypedLiteralUnsafe(this.predicate, object, dt);
        } else {
            this.typedLiteralQueue.offer(this.predicate);
            this.typedLiteralQueue.offer(object);
            this.typedLiteralQueue.offer(dt);
        }
    }

    private void addTypedLiteralUnsafe(String predicate, String object, String dt) {
        try {
            boolean reversed = this.reversed ^ "@reverse".equals(this.getDtMapping(predicate));
            if (reversed) {
                this.sink.addNonLiteral(object, this.resolve(predicate), this.subject, this.graph);
            } else {
                this.sink.addTypedLiteral(this.subject, this.resolve(predicate), object, this.resolve(dt), this.graph);
            }
        }
        catch (MalformedIriException e) {
            // empty catch block
        }
    }

    private String resolve(String value) throws MalformedIriException {
        return this.resolve(value, true, true);
    }

    private String resolve(String value, boolean ignoreRelIri, boolean useVocab) throws MalformedIriException {
        if (value == null || value.startsWith("_:")) {
            return value;
        }
        if (value.isEmpty()) {
            throw new MalformedIriException("Empty IRI");
        }
        try {
            String mapping = this.resolveMapping(value, useVocab);
            if (mapping != null && mapping.charAt(0) != '@') {
                if (mapping.startsWith("_:")) {
                    return mapping;
                }
                return this.resolveCurieOrIri(mapping, false);
            }
        }
        catch (MalformedIriException e) {
            // empty catch block
        }
        return this.resolveCurieOrIri(value, ignoreRelIri);
    }

    String resolveMapping(String value) throws MalformedIriException {
        return this.resolveMapping(value, true);
    }

    String resolveMapping(String value, boolean useVocab) throws MalformedIriException {
        if (this.iriMappings.containsKey(value)) {
            return this.iriMappings.get(value);
        }
        if (!this.nullified && this.parent != null) {
            try {
                return this.parent.resolveMapping(value, false);
            }
            catch (MalformedIriException malformedIriException) {
                // empty catch block
            }
        }
        if (useVocab && this.vocab != null && value.indexOf(58) == -1) {
            return this.vocab + value;
        }
        throw new MalformedIriException("Can't resolve term " + value);
    }

    String resolveCurieOrIri(String curie, boolean ignoreRelIri) throws MalformedIriException {
        block9: {
            if (!ignoreRelIri && (curie == null || curie.isEmpty())) {
                return this.resolveIri(curie);
            }
            int delimPos = curie.indexOf(58);
            if (delimPos == -1) {
                if (ignoreRelIri) {
                    throw new MalformedCurieException("CURIE with no prefix (" + curie + ") found");
                }
                return this.resolveIri(curie);
            }
            String suffix = curie.substring(delimPos + 1);
            if (suffix.startsWith("//")) {
                return this.resolveIri(curie);
            }
            String prefix = curie.substring(0, delimPos);
            if (prefix.equals("_")) {
                throw new MalformedCurieException("CURIE with invalid prefix (" + curie + ") found");
            }
            try {
                String prefixUri = this.resolveMapping(prefix);
                if (prefixUri != null) {
                    return prefixUri + suffix;
                }
                if (RIUtils.isIri((String)curie)) {
                    return curie;
                }
            }
            catch (MalformedIriException e) {
                if (!RIUtils.isIri((String)curie)) break block9;
                return curie;
            }
        }
        throw new MalformedIriException("Malformed IRI: " + curie);
    }

    private String resolveIri(String iri) throws MalformedIriException {
        String base = this.getBase();
        if ("@@dociri".equals(base)) {
            return RIUtils.resolveIri((String)this.documentContext.iri, (String)iri);
        }
        return RIUtils.resolveIri((String)base, (String)iri);
    }

    public boolean isParsingContext() {
        return this.parent != null && ("@context".equals(this.parent.predicate) || this.parent.parent != null && "@context".equals(this.parent.parent.predicate));
    }

    public void processContext(EvalContext context) {
        this.iriMappings.putAll(context.iriMappings);
        this.dtMappings.putAll(context.dtMappings);
        this.langMappings.putAll(context.langMappings);
        this.lang = context.lang;
        this.base = context.base;
        this.vocab = context.vocab;
        this.updateState(2);
        this.children.remove(context);
    }

    public boolean hasIdDeclared() {
        return (this.state & 1) == 1;
    }
}

