/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.jsonld;

import java.util.Deque;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.semarglproject.jsonld.DocumentContext;
import org.semarglproject.jsonld.EvalContext;
import org.semarglproject.ri.MalformedIriException;
import org.semarglproject.sink.QuadSink;

final class JsonLdContentHandler {
    private static final Pattern TERM_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+", 32);
    private Deque<EvalContext> contextStack = new LinkedList<EvalContext>();
    private final DocumentContext dh = new DocumentContext();
    private EvalContext currentContext;
    private final QuadSink sink;

    public JsonLdContentHandler(QuadSink sink) {
        this.sink = sink;
    }

    public void onDocumentStart() {
        this.currentContext = EvalContext.createInitialContext(this.dh, this.sink);
    }

    public void onDocumentEnd() {
        this.clear();
    }

    public void onObjectStart() {
        String dt;
        String graph = null;
        if ("@graph".equals(this.currentContext.predicate) && (this.contextStack.size() > 1 || this.currentContext.hasNonGraphContextProps)) {
            graph = this.currentContext.subject;
        }
        this.contextStack.push(this.currentContext);
        this.currentContext = this.currentContext.initChildContext(graph);
        if (this.contextStack.size() == 1) {
            this.currentContext.updateState(4);
        }
        if ("@reverse".equals(this.currentContext.parent.predicate)) {
            this.currentContext.subject = this.currentContext.parent.subject;
            this.currentContext.reversed = true;
            this.currentContext.containerType = "@reverse";
            this.currentContext.updateState(1);
        } else if (this.contextStack.size() > 1 && "@container@index".equals(dt = this.currentContext.getDtMapping(this.currentContext.parent.predicate))) {
            this.currentContext.subject = this.currentContext.parent.subject;
            this.currentContext.index = true;
        }
    }

    public void onObjectEnd() {
        boolean nullObject;
        this.unwrap();
        if (this.currentContext.objectLit != null) {
            if (this.contextStack.size() > 1 && !"@@null".equals(this.currentContext.objectLit)) {
                if (this.currentContext.objectLitDt != null) {
                    this.currentContext.parent.addTypedLiteral(this.currentContext.objectLit, this.currentContext.objectLitDt);
                } else {
                    this.currentContext.parent.addPlainLiteral(this.currentContext.objectLit, this.currentContext.lang);
                }
            }
            this.currentContext.updateState(4);
        } else if (!this.currentContext.isParsingContext() && !this.currentContext.index) {
            this.addSubjectTypeDefinition(this.currentContext.objectLitDt, this.currentContext.base);
            if (this.contextStack.size() > 1 && this.currentContext.containerType == null) {
                this.addSubjectTypeDefinition(this.currentContext.parent.getDtMapping(this.currentContext.parent.predicate), this.currentContext.parent.base);
                if (!"@set".equals(this.currentContext.parent.predicate) || this.currentContext.hasProps) {
                    this.currentContext.parent.addNonLiteral(this.currentContext.parent.predicate, this.currentContext.subject, this.currentContext.base);
                }
            }
        }
        boolean bl = nullObject = !this.currentContext.hasProps && "@@null".equals(this.currentContext.subject);
        if (this.currentContext.isParsingContext()) {
            this.currentContext.parent.processContext(this.currentContext);
        }
        this.currentContext.updateState(3);
        this.currentContext = this.contextStack.pop();
        if (nullObject) {
            this.onNull();
        }
    }

    public void onArrayStart() {
        this.currentContext.parsingArray = true;
    }

    public void onArrayEnd() {
        String dt;
        this.currentContext.parsingArray = false;
        if ("@list".equals(this.currentContext.predicate)) {
            if (this.currentContext.listTail != null) {
                this.currentContext.addListRest("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
            } else {
                this.currentContext.subject = "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil";
                this.currentContext.containerType = null;
            }
        } else if ("@set".equals(this.currentContext.predicate)) {
            this.currentContext.objectLit = "@@null";
        } else if (this.currentContext.predicate != null && "@container@list".equals(dt = this.currentContext.getDtMapping(this.currentContext.predicate))) {
            try {
                this.currentContext.addNonLiteral(this.currentContext.resolveMapping(this.currentContext.predicate), "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil", this.currentContext.base);
            }
            catch (MalformedIriException malformedIriException) {
                // empty catch block
            }
        }
    }

    private void unwrap() {
        if (this.currentContext.parsingArray) {
            this.onArrayEnd();
        }
        if (!this.currentContext.wrapped) {
            return;
        }
        this.currentContext.wrapped = false;
        this.onObjectEnd();
    }

    public void onKey(String key) {
        String dt;
        this.unwrap();
        if (this.currentContext.index && !key.startsWith("@")) {
            key = this.currentContext.parent.predicate;
        } else if (this.currentContext.parent != null && this.currentContext.parent.predicate != null && "@container@language".equals(dt = this.currentContext.getDtMapping(this.currentContext.parent.predicate))) {
            this.currentContext.lang = key;
            key = this.currentContext.parent.predicate;
            this.currentContext.containerType = "@language";
            this.currentContext.subject = this.currentContext.parent.subject;
        }
        try {
            String mapping = this.currentContext.resolveMapping(key);
            try {
                if (mapping != null) {
                    mapping = this.currentContext.resolveMapping(mapping);
                }
            }
            catch (MalformedIriException malformedIriException) {
                // empty catch block
            }
            if (mapping != null && mapping.charAt(0) == '@') {
                this.currentContext.predicate = mapping;
                if (mapping.equals("@set") || mapping.equals("@list")) {
                    this.currentContext.containerType = mapping;
                }
            } else {
                this.currentContext.predicate = key;
            }
        }
        catch (MalformedIriException e) {
            this.currentContext.predicate = key;
        }
        if ("@set".equals(this.currentContext.predicate) || "@list".equals(this.currentContext.predicate)) {
            this.onArrayStart();
        }
        if (!"@graph".equals(this.currentContext.predicate) && !"@context".equals(this.currentContext.predicate)) {
            this.currentContext.hasNonGraphContextProps = true;
            if (!this.currentContext.predicate.startsWith("@")) {
                this.currentContext.hasProps = true;
            }
        }
    }

    public void onString(String value) {
        if (this.currentContext.isParsingContext()) {
            EvalContext parentContext = this.currentContext.parent;
            if (parentContext.isParsingContext()) {
                if ("@id".equals(this.currentContext.predicate)) {
                    parentContext.defineIriMappingForPredicate(value);
                } else if ("@type".equals(this.currentContext.predicate)) {
                    parentContext.defineDtMappingForPredicate(value);
                } else if ("@language".equals(this.currentContext.predicate)) {
                    parentContext.defineLangMappingForPredicate(value);
                } else if ("@container".equals(this.currentContext.predicate)) {
                    parentContext.defineDtMappingForPredicate("@container" + value);
                } else if ("@reverse".equals(this.currentContext.predicate)) {
                    parentContext.defineIriMappingForPredicate(value);
                    parentContext.defineDtMappingForPredicate("@reverse");
                }
                return;
            }
            if (!this.currentContext.isPredicateKeyword()) {
                this.currentContext.defineIriMappingForPredicate(value);
                return;
            }
            if ("@base".equals(this.currentContext.predicate)) {
                this.currentContext.base = value;
                return;
            }
            if ("@vocab".equals(this.currentContext.predicate)) {
                this.currentContext.vocab = value;
                return;
            }
        } else if (!this.currentContext.isPredicateKeyword() && this.currentContext.predicate != null) {
            String dt = this.currentContext.getDtMapping(this.currentContext.predicate);
            if ("@container@list".equals(dt)) {
                this.onObjectStart();
                this.onKey("@list");
                this.onArrayStart();
                this.onString(value);
                this.currentContext.wrapped = true;
            } else if ("@vocab".equals(dt)) {
                String valueMapping;
                try {
                    valueMapping = this.currentContext.resolveMapping(value);
                }
                catch (MalformedIriException e) {
                    valueMapping = value;
                }
                this.currentContext.addNonLiteral(this.currentContext.predicate, valueMapping, this.currentContext.base);
            } else if ("@id".equals(dt)) {
                try {
                    String resolvedValue = this.currentContext.resolveCurieOrIri(value, false);
                    this.currentContext.addNonLiteral(this.currentContext.predicate, resolvedValue, this.currentContext.base);
                }
                catch (MalformedIriException e) {
                    this.currentContext.addPlainLiteral(value, "@language");
                }
            } else if ("@language".equals(this.currentContext.containerType)) {
                this.currentContext.addPlainLiteral(value, this.currentContext.lang);
            } else {
                this.currentContext.addPlainLiteral(value, "@language");
            }
            return;
        }
        if (this.currentContext.isPredicateKeyword()) {
            if ("@type".equals(this.currentContext.predicate)) {
                if (this.currentContext.parsingArray) {
                    this.addSubjectTypeDefinition(value, this.currentContext.base);
                } else {
                    this.currentContext.objectLitDt = value;
                }
            } else if ("@language".equals(this.currentContext.predicate)) {
                this.currentContext.lang = value;
            } else if ("@id".equals(this.currentContext.predicate)) {
                if (this.currentContext.index) {
                    this.currentContext.addNonLiteral(this.currentContext.parent.predicate, value, this.currentContext.base);
                } else {
                    this.currentContext.subject = TERM_PATTERN.matcher(value).matches() ? "./" + value : value;
                }
                this.currentContext.updateState(1);
            } else if ("@value".equals(this.currentContext.predicate)) {
                this.currentContext.objectLit = value;
            } else if ("@list".equals(this.currentContext.predicate) && this.isNotFloating()) {
                if (this.currentContext.listTail == null) {
                    this.currentContext.listTail = this.currentContext.subject;
                    this.currentContext.addListFirst(value);
                } else {
                    this.currentContext.addListRest(this.dh.createBnode(false));
                    this.currentContext.addListFirst(value);
                }
            } else if ("@set".equals(this.currentContext.predicate) && this.isNotFloating()) {
                this.currentContext.addToSet(value);
            }
        }
    }

    private boolean isNotFloating() {
        return this.currentContext.parent != null && this.currentContext.parent.predicate != null && !this.currentContext.parent.predicate.startsWith("@");
    }

    private void addSubjectTypeDefinition(String dt, String base) {
        if (dt == null || dt.charAt(0) == '@') {
            return;
        }
        this.currentContext.addNonLiteral("http://www.w3.org/1999/02/22-rdf-syntax-ns#type", dt, base);
    }

    public void onBoolean(boolean value) {
        this.processTypedValue(Boolean.toString(value), "http://www.w3.org/2001/XMLSchema#boolean");
    }

    public void onNull() {
        if ("@context".equals(this.currentContext.predicate)) {
            this.currentContext.nullify();
        } else if ("@value".equals(this.currentContext.predicate)) {
            this.currentContext.objectLit = "@@null";
        } else if ("@id".equals(this.currentContext.predicate)) {
            this.currentContext.subject = "@@null";
        } else if (this.currentContext.isParsingContext()) {
            EvalContext parentContext = this.currentContext.parent;
            if (parentContext.isParsingContext()) {
                if ("@language".equals(this.currentContext.predicate)) {
                    parentContext.defineLangMappingForPredicate("@@null");
                }
            } else if ("@language".equals(this.currentContext.predicate)) {
                this.currentContext.lang = null;
            } else if ("@base".equals(this.currentContext.predicate)) {
                this.currentContext.base = "@@dociri";
            } else if ("@vocab".equals(this.currentContext.predicate)) {
                this.currentContext.vocab = null;
            } else {
                this.currentContext.defineIriMappingForPredicate(null);
            }
        }
    }

    public void onNumber(double value) {
        this.processTypedValue(Double.toString(value), "http://www.w3.org/2001/XMLSchema#double");
    }

    public void onNumber(int value) {
        this.processTypedValue(Integer.toString(value), "http://www.w3.org/2001/XMLSchema#integer");
    }

    public void processTypedValue(String value, String defaultDt) {
        String predicateDt = this.currentContext.getDtMapping(this.currentContext.predicate);
        if ("@container@list".equals(predicateDt)) {
            this.onObjectStart();
            this.onKey("@list");
            this.onArrayStart();
            this.currentContext.wrapped = true;
        } else if ("@container@set".equals(predicateDt)) {
            this.onObjectStart();
            this.onKey("@set");
            this.onArrayStart();
            this.currentContext.wrapped = true;
        }
        String dt = this.currentContext.getDtMapping(this.currentContext.predicate);
        if (dt == null) {
            dt = defaultDt;
        }
        if ("@list".equals(this.currentContext.predicate) && this.isNotFloating()) {
            if (this.currentContext.listTail == null) {
                this.currentContext.listTail = this.currentContext.subject;
                this.currentContext.addListFirst(value, dt);
            } else {
                this.currentContext.addListRest(this.dh.createBnode(false));
                this.currentContext.addListFirst(value, dt);
            }
        } else if ("@set".equals(this.currentContext.predicate) && this.isNotFloating()) {
            this.currentContext.addToSet(value, dt);
        } else {
            this.currentContext.addTypedLiteral(value, dt);
        }
    }

    private void clear() {
        this.dh.clear();
        this.contextStack.clear();
        this.currentContext = null;
    }

    public void setBaseUri(String baseUri) {
        this.dh.iri = baseUri;
    }
}

