/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.jsonld;

import java.util.BitSet;
import java.util.Deque;
import java.util.LinkedList;
import org.semarglproject.jsonld.JsonLdContentHandler;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.rdf.ProcessorGraphHandler;
import org.semarglproject.sink.CharSink;
import org.semarglproject.sink.DataSink;
import org.semarglproject.sink.Pipe;
import org.semarglproject.sink.QuadSink;
import org.semarglproject.sink.TripleSink;

public final class JsonLdParser
extends Pipe<TripleSink>
implements CharSink {
    public static final String ERROR = "http://semarglproject.org/json-ld/Error";
    public static final String WARNING = "http://semarglproject.org/json-ld/Warning";
    private static final short PARSING_ARRAY_BEFORE_VALUE = 1;
    private static final short PARSING_OBJECT_BEFORE_KEY = 2;
    private static final short PARSING_OBJECT_BEFORE_VALUE = 3;
    private static final short PARSING_STRING = 4;
    private static final short PARSING_NUMBER = 5;
    private static final short PARSING_NAMED_LITERAL = 6;
    private static final short PARSING_OBJECT_BEFORE_COLON = 7;
    private static final short PARSING_OBJECT_BEFORE_COMMA = 8;
    private static final short PARSING_ARRAY_BEFORE_COMMA = 9;
    private static final BitSet WHITESPACE = new BitSet();
    private static final BitSet NAMED_LITERAL_CHAR = new BitSet();
    private JsonLdContentHandler contentHandler;
    private ProcessorGraphHandler processorGraphHandler = null;
    private boolean ignoreErrors = false;
    private Deque<Short> stateStack = new LinkedList<Short>();
    private short parsingState;
    private int tokenStartPos;
    private short charsToEscape = 0;
    private StringBuilder addBuffer = null;

    private JsonLdParser(QuadSink sink) {
        super((DataSink)sink);
        this.contentHandler = new JsonLdContentHandler(sink);
    }

    public static CharSink connect(QuadSink sink) {
        return new JsonLdParser(sink);
    }

    public void warning(String warningClass, String msg) {
        if (this.processorGraphHandler != null) {
            this.processorGraphHandler.warning(warningClass, msg);
        }
    }

    private void error(String msg) throws ParseException {
        if (this.processorGraphHandler != null) {
            this.processorGraphHandler.error(ERROR, msg);
        }
        if (!this.ignoreErrors) {
            throw new ParseException(msg);
        }
    }

    public JsonLdParser process(String str) throws ParseException {
        return this.process(str.toCharArray(), 0, str.length());
    }

    public JsonLdParser process(char ch) throws ParseException {
        char[] buffer = new char[]{ch};
        return this.process(buffer, 0, 1);
    }

    public JsonLdParser process(char[] buffer, int start, int count) throws ParseException {
        if (this.tokenStartPos != -1) {
            this.tokenStartPos = start;
        }
        int end = start + count;
        for (int pos = start; pos < end; ++pos) {
            if (this.parsingState == 1 || this.parsingState == 3 || this.parsingState == 2) {
                this.processValueChar(buffer, pos);
                continue;
            }
            if (this.parsingState == 4) {
                this.processStringChar(buffer, pos);
                continue;
            }
            if (this.parsingState == 8) {
                if (buffer[pos] == ',') {
                    this.parsingState = (short)2;
                    continue;
                }
                if (buffer[pos] == '}') {
                    this.parsingState = this.stateStack.pop();
                    this.contentHandler.onObjectEnd();
                    this.onValue();
                    continue;
                }
                if (WHITESPACE.get(buffer[pos])) continue;
                this.error("Unexpected character '" + buffer[pos] + "'");
                continue;
            }
            if (this.parsingState == 9) {
                if (buffer[pos] == ',') {
                    this.parsingState = 1;
                    continue;
                }
                if (buffer[pos] == ']') {
                    this.parsingState = this.stateStack.pop();
                    this.contentHandler.onArrayEnd();
                    this.onValue();
                    continue;
                }
                if (WHITESPACE.get(buffer[pos])) continue;
                this.error("Unexpected character '" + buffer[pos] + "'");
                continue;
            }
            if (this.parsingState == 7) {
                if (buffer[pos] == ':') {
                    this.parsingState = (short)3;
                    continue;
                }
                if (WHITESPACE.get(buffer[pos])) continue;
                this.error("Unexpected character '" + buffer[pos] + "'");
                continue;
            }
            if (this.parsingState != 6 && this.parsingState != 5 || NAMED_LITERAL_CHAR.get(buffer[pos])) continue;
            String value = this.unescape(this.extractToken(buffer, pos - 1, 0));
            if (this.parsingState == 6) {
                if ("true".equals(value)) {
                    this.contentHandler.onBoolean(true);
                } else if ("false".equals(value)) {
                    this.contentHandler.onBoolean(false);
                } else if ("null".equals(value)) {
                    this.contentHandler.onNull();
                } else {
                    this.error("Unexpected value '" + value + "'");
                }
            } else if (value.contains(".") || value.contains("E") || value.contains("e")) {
                this.contentHandler.onNumber(Double.valueOf(value));
            } else {
                this.contentHandler.onNumber(Integer.valueOf(value));
            }
            this.parsingState = this.stateStack.pop();
            if (this.parsingState == 1) {
                this.parsingState = (short)9;
            } else if (this.parsingState == 3) {
                this.parsingState = (short)8;
            }
            --pos;
        }
        if (this.tokenStartPos != -1) {
            if (this.addBuffer == null) {
                this.addBuffer = new StringBuilder();
            }
            this.addBuffer.append(buffer, this.tokenStartPos, end - this.tokenStartPos);
        }
        return this;
    }

    private void processStringChar(char[] buffer, int pos) throws ParseException {
        if (this.charsToEscape > 0) {
            this.charsToEscape = (short)(this.charsToEscape - 1);
        } else if (buffer[pos] == '\"') {
            this.parsingState = this.stateStack.pop();
            String value = this.unescape(this.extractToken(buffer, pos, 1));
            if (this.parsingState == 2) {
                this.contentHandler.onKey(value);
                this.parsingState = (short)7;
            } else if (this.parsingState == 1) {
                this.contentHandler.onString(value);
                this.parsingState = (short)9;
            } else if (this.parsingState == 3) {
                this.contentHandler.onString(value);
                this.parsingState = (short)8;
            }
        } else if (buffer[pos] == '\\') {
            this.charsToEscape = 1;
        }
    }

    private void processValueChar(char[] buffer, int pos) throws ParseException {
        switch (buffer[pos]) {
            case '{': {
                this.stateStack.push(this.parsingState);
                this.parsingState = (short)2;
                this.contentHandler.onObjectStart();
                break;
            }
            case '}': {
                if (this.parsingState == 3) {
                    this.error("Unexpected object end");
                }
                this.parsingState = this.stateStack.pop();
                this.contentHandler.onObjectEnd();
                this.onValue();
                break;
            }
            case '[': {
                this.stateStack.push(this.parsingState);
                this.parsingState = 1;
                this.contentHandler.onArrayStart();
                break;
            }
            case ']': {
                this.parsingState = this.stateStack.pop();
                this.contentHandler.onArrayEnd();
                this.onValue();
                break;
            }
            case 'f': 
            case 'n': 
            case 't': {
                this.stateStack.push(this.parsingState);
                this.parsingState = (short)6;
                this.tokenStartPos = pos;
                break;
            }
            case '\"': {
                this.stateStack.push(this.parsingState);
                this.parsingState = (short)4;
                this.tokenStartPos = pos;
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.stateStack.push(this.parsingState);
                this.parsingState = (short)5;
                this.tokenStartPos = pos;
                break;
            }
            default: {
                if (WHITESPACE.get(buffer[pos])) break;
                this.error("Unexpected character '" + buffer[pos] + "'");
            }
        }
    }

    private void onValue() {
        if (this.parsingState == 1) {
            this.parsingState = (short)9;
        } else if (this.parsingState == 3) {
            this.parsingState = (short)8;
        }
    }

    public void setBaseUri(String baseUri) {
        this.contentHandler.setBaseUri(baseUri);
    }

    protected boolean setPropertyInternal(String key, Object value) {
        if ("http://semarglproject.org/core/properties/processor-graph-handler".equals(key) && value instanceof ProcessorGraphHandler) {
            this.processorGraphHandler = (ProcessorGraphHandler)value;
        } else if ("http://semarglproject.org/core/properties/enable-error-recovery".equals(key) && value instanceof Boolean) {
            this.ignoreErrors = (Boolean)value;
        }
        return false;
    }

    private String extractToken(char[] buffer, int tokenEndPos, int trimSize) throws ParseException {
        String saved;
        if (this.addBuffer != null) {
            if (tokenEndPos - trimSize >= this.tokenStartPos) {
                this.addBuffer.append(buffer, this.tokenStartPos, tokenEndPos - this.tokenStartPos - trimSize + 1);
            }
            this.addBuffer.delete(0, trimSize);
            saved = this.addBuffer.toString();
            this.addBuffer = null;
        } else {
            saved = String.valueOf(buffer, this.tokenStartPos + trimSize, tokenEndPos - this.tokenStartPos + 1 - 2 * trimSize);
        }
        this.tokenStartPos = -1;
        return saved;
    }

    public void startStream() throws ParseException {
        super.startStream();
        this.parsingState = 1;
        this.contentHandler.onDocumentStart();
    }

    public void endStream() throws ParseException {
        super.endStream();
        this.contentHandler.onDocumentEnd();
        if (this.tokenStartPos != -1 || !this.stateStack.isEmpty()) {
            this.error("Unexpected end of stream");
        }
    }

    private String unescape(String str) throws ParseException {
        int limit = str.length();
        StringBuilder result = new StringBuilder(limit);
        block11: for (int i = 0; i < limit; ++i) {
            char ch = str.charAt(i);
            if (ch != '\\') {
                result.append(ch);
                continue;
            }
            if (++i == limit) break;
            ch = str.charAt(i);
            switch (ch) {
                case '\"': 
                case '/': 
                case '\\': {
                    result.append(ch);
                    continue block11;
                }
                case 'b': {
                    result.append('\b');
                    continue block11;
                }
                case 'f': {
                    result.append('\f');
                    continue block11;
                }
                case 'n': {
                    result.append('\n');
                    continue block11;
                }
                case 'r': {
                    result.append('\r');
                    continue block11;
                }
                case 't': {
                    result.append('\t');
                    continue block11;
                }
                case 'u': {
                    int sequenceLength = 4;
                    if (i + sequenceLength >= limit) {
                        this.error("Error parsing escape sequence '\\" + ch + "'");
                    }
                    String code = str.substring(i + 1, i + 1 + sequenceLength);
                    i += sequenceLength;
                    try {
                        int value = Integer.parseInt(code, 16);
                        result.append((char)value);
                    }
                    catch (NumberFormatException nfe) {
                        this.error("Error parsing escape sequence '\\" + ch + "'");
                    }
                    continue block11;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    static {
        WHITESPACE.set(9);
        WHITESPACE.set(32);
        WHITESPACE.set(13);
        WHITESPACE.set(10);
        NAMED_LITERAL_CHAR.set(116);
        NAMED_LITERAL_CHAR.set(114);
        NAMED_LITERAL_CHAR.set(117);
        NAMED_LITERAL_CHAR.set(101);
        NAMED_LITERAL_CHAR.set(102);
        NAMED_LITERAL_CHAR.set(97);
        NAMED_LITERAL_CHAR.set(108);
        NAMED_LITERAL_CHAR.set(115);
        NAMED_LITERAL_CHAR.set(110);
        NAMED_LITERAL_CHAR.set(48);
        NAMED_LITERAL_CHAR.set(49);
        NAMED_LITERAL_CHAR.set(50);
        NAMED_LITERAL_CHAR.set(51);
        NAMED_LITERAL_CHAR.set(52);
        NAMED_LITERAL_CHAR.set(53);
        NAMED_LITERAL_CHAR.set(54);
        NAMED_LITERAL_CHAR.set(55);
        NAMED_LITERAL_CHAR.set(56);
        NAMED_LITERAL_CHAR.set(57);
        NAMED_LITERAL_CHAR.set(46);
        NAMED_LITERAL_CHAR.set(45);
        NAMED_LITERAL_CHAR.set(69);
        NAMED_LITERAL_CHAR.set(43);
    }
}

