/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.semarglproject.rdf.ParseException;
import org.testng.Assert;

public final class NTriplesTestBundle {
    private static final String FAILURES_DIR = "target/n3_failed/";
    private static final String RDF_TEST_SUITE_ROOT = "http://www.w3.org/2000/10/rdf-tests/rdfcore/";

    public static Object[][] getTestFiles() throws IOException {
        String manifestUri = "http://www.w3.org/2000/10/rdf-tests/rdfcore//Manifest.rdf";
        Model graph = ModelFactory.createDefaultModel();
        graph.read(NTriplesTestBundle.openStreamForResource("w3c/Manifest.rdf"), manifestUri, "RDF/XML");
        String queryStr = IOUtils.toString((InputStream)NTriplesTestBundle.openStreamForResource("fetch_ntriples_tests.sparql"));
        Query query = QueryFactory.create((String)queryStr, (String)manifestUri);
        QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)graph);
        ResultSet rs = qe.execSelect();
        ArrayList<String> result = new ArrayList<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            String testName = qs.getResource("ntriples_file").getURI();
            result.add(testName);
        }
        qe.close();
        int i = 0;
        Object[][] res = new Object[result.size()][];
        for (String str : result) {
            res[i++] = new Object[]{str};
        }
        return res;
    }

    public static void prepareTestDir() {
        try {
            File testDir = new File(FAILURES_DIR);
            testDir.mkdirs();
            FileUtils.cleanDirectory((File)testDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTest(String testUrl, SaveToFileCallback callback) {
        String resultFileName = testUrl.substring(testUrl.lastIndexOf(47) + 1).replace(".nt", ".ttl");
        String resultFilePath = FAILURES_DIR + resultFileName;
        try {
            InputStreamReader input = new InputStreamReader(NTriplesTestBundle.openStreamForResource(testUrl), "UTF-8");
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(resultFilePath), "UTF-8");
            try {
                callback.run(input, testUrl, output);
            }
            finally {
                IOUtils.closeQuietly((Reader)input);
                IOUtils.closeQuietly((Writer)output);
            }
        }
        catch (ParseException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        try {
            Model result = NTriplesTestBundle.createModelFromFile(resultFilePath, testUrl);
            Model expected = NTriplesTestBundle.createModelFromFile(testUrl, testUrl);
            Assert.assertTrue((boolean)result.isIsomorphicWith(expected));
        }
        catch (FileNotFoundException e) {
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Model createModelFromFile(String filename, String baseUri) throws FileNotFoundException {
        String fileFormat = NTriplesTestBundle.detectFileFormat(filename);
        Model result = ModelFactory.createDefaultModel();
        InputStream inputStream = NTriplesTestBundle.openStreamForResource(filename);
        try {
            result.read(inputStream, baseUri, fileFormat);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    private static String detectFileFormat(String filename) {
        String fileFormat;
        if (filename.endsWith(".nt")) {
            fileFormat = "N-TRIPLE";
        } else if (filename.endsWith(".ttl")) {
            fileFormat = "TURTLE";
        } else if (filename.endsWith(".rdf")) {
            fileFormat = "RDF/XML";
        } else {
            throw new IllegalArgumentException("Unknown file format");
        }
        return fileFormat;
    }

    private static InputStream openStreamForResource(String uri) throws FileNotFoundException {
        File file;
        String result = uri;
        if (uri.startsWith(RDF_TEST_SUITE_ROOT)) {
            result = uri.replace(RDF_TEST_SUITE_ROOT, "w3c/");
        }
        if ((file = new File(result)).exists()) {
            return new FileInputStream(file);
        }
        result = NTriplesTestBundle.class.getClassLoader().getResource(result).getFile();
        if (result.contains(".jar!/")) {
            try {
                return new URL("jar:" + result).openStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        return new FileInputStream(result);
    }

    public static interface SaveToFileCallback {
        public void run(Reader var1, String var2, Writer var3) throws ParseException;
    }
}

