/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.semarglproject.rdf.ParseException;
import org.testng.Assert;

public final class RdfXmlTestBundle {
    private static final String FAILURES_DIR = "target/failed/";
    private static final String ARP_TESTSUITE_ROOT = "http://jcarroll.hpl.hp.com/arp-tests/";
    private static final String ARP_TESTSUITE_MANIFEST_URI = "http://jcarroll.hpl.hp.com/arp-tests/Manifest.rdf";
    private static final String W3C_TESTSUITE_ROOT = "http://www.w3.org/2000/10/rdf-tests/rdfcore/";
    private static final String W3C_TESTSUITE_MANIFEST_URI = "http://www.w3.org/2000/10/rdf-tests/rdfcore/Manifest.rdf";
    public static final String FETCH_RDFXML_TESTS_SPARQL = "fetch_rdfxml_tests.sparql";

    public static Object[][] getTestFiles() {
        List<TestCase> testCases = RdfXmlTestBundle.getTestCases(W3C_TESTSUITE_MANIFEST_URI, W3C_TESTSUITE_ROOT);
        testCases.addAll(RdfXmlTestBundle.getTestCases(ARP_TESTSUITE_MANIFEST_URI, ARP_TESTSUITE_ROOT));
        Object[][] result = new Object[testCases.size()][];
        for (int i = 0; i < testCases.size(); ++i) {
            result[i] = new Object[]{testCases.get(i)};
        }
        return result;
    }

    public static void prepareTestDir() {
        try {
            File testDir = new File(FAILURES_DIR);
            testDir.mkdirs();
            FileUtils.cleanDirectory((File)testDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static List<TestCase> getTestCases(String manifestUri, String testsuiteRoot) {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        String queryStr = null;
        Model graph = ModelFactory.createDefaultModel();
        try {
            graph.read(RdfXmlTestBundle.openStreamForResource(manifestUri), manifestUri, "RDF/XML");
            queryStr = IOUtils.toString((InputStream)RdfXmlTestBundle.openStreamForResource(FETCH_RDFXML_TESTS_SPARQL));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Query query = QueryFactory.create(queryStr, (String)manifestUri);
        QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)graph);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            String testName = qs.getResource("test_case").getURI().replace(testsuiteRoot, "");
            String input = qs.getResource("input").getURI();
            String result = null;
            if (qs.getResource("result") != null) {
                result = qs.getResource("result").getURI();
            }
            if (input.endsWith("rdfms-empty-property-elements/test013.rdf") || input.endsWith("rdfms-not-id-and-resource-attr/test002.rdf") || input.endsWith("rdfms-not-id-and-resource-attr/test005.rdf") || input.endsWith("rdfms-xml-literal-namespaces/test002.rdf") || input.endsWith("xml-literals/html.rdf") || input.endsWith("xml-literals/reported1.rdf") || input.endsWith("xml-literals/reported2.rdf") || input.endsWith("xml-literals/reported3.rdf") || input.endsWith("i18n/t9000.rdf")) continue;
            testCases.add(new TestCase(testName, input, result));
        }
        qe.close();
        return testCases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTestWith(TestCase testCase, SaveToFileCallback callback) {
        String inputUri = testCase.getInput();
        String resultFilePath = RdfXmlTestBundle.getOutputPath(inputUri);
        new File(resultFilePath).getParentFile().mkdirs();
        boolean invalidRdfXmlFile = false;
        try {
            InputStreamReader input = new InputStreamReader(RdfXmlTestBundle.openStreamForResource(inputUri), "UTF-8");
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(resultFilePath), "UTF-8");
            try {
                callback.run(input, inputUri, output);
            }
            finally {
                IOUtils.closeQuietly((Reader)input);
                IOUtils.closeQuietly((Writer)output);
            }
        }
        catch (IOException e) {
            Assert.fail();
        }
        catch (ParseException e) {
            invalidRdfXmlFile = true;
        }
        try {
            Model inputModel = invalidRdfXmlFile ? ModelFactory.createDefaultModel() : RdfXmlTestBundle.createModelFromFile(resultFilePath, inputUri);
            Model expected = testCase.getResult() == null ? ModelFactory.createDefaultModel() : RdfXmlTestBundle.createModelFromFile(testCase.getResult(), inputUri);
            Assert.assertTrue((boolean)inputModel.isIsomorphicWith(expected));
        }
        catch (FileNotFoundException e) {
            Assert.fail();
        }
    }

    private static String getOutputPath(String uri) {
        String result = uri;
        if (uri.startsWith(W3C_TESTSUITE_ROOT)) {
            result = uri.replace(W3C_TESTSUITE_ROOT, "target/failed/w3c/");
        } else if (uri.startsWith(ARP_TESTSUITE_ROOT)) {
            result = uri.replace(ARP_TESTSUITE_ROOT, "target/failed/arp/");
        }
        return result + ".out.ttl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Model createModelFromFile(String filename, String baseUri) throws FileNotFoundException {
        String fileFormat = RdfXmlTestBundle.detectFileFormat(filename);
        Model result = ModelFactory.createDefaultModel();
        InputStream inputStream = RdfXmlTestBundle.openStreamForResource(filename);
        try {
            result.read(inputStream, baseUri, fileFormat);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    private static String detectFileFormat(String filename) {
        String fileFormat;
        if (filename.endsWith(".nt")) {
            fileFormat = "N-TRIPLE";
        } else if (filename.endsWith(".ttl")) {
            fileFormat = "TURTLE";
        } else if (filename.endsWith(".rdf")) {
            fileFormat = "RDF/XML";
        } else {
            throw new IllegalArgumentException("Unknown file format");
        }
        return fileFormat;
    }

    private static InputStream openStreamForResource(String uri) throws FileNotFoundException {
        String result = uri;
        if (uri.startsWith(W3C_TESTSUITE_ROOT)) {
            result = uri.replace(W3C_TESTSUITE_ROOT, "w3c/");
        } else if (uri.startsWith(ARP_TESTSUITE_ROOT)) {
            result = uri.replace(ARP_TESTSUITE_ROOT, "arp/");
        }
        File file = new File(result);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        result = RdfXmlTestBundle.class.getClassLoader().getResource(result).getFile();
        if (result.contains(".jar!/")) {
            try {
                return new URL("jar:" + result).openStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        return new FileInputStream(result);
    }

    public static final class TestCase {
        private final String name;
        private final String input;
        private final String result;

        public TestCase(String name, String input, String result) {
            this.name = name;
            this.input = input;
            this.result = result;
        }

        public String getInput() {
            return this.input;
        }

        public String getResult() {
            return this.result;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface SaveToFileCallback {
        public void run(Reader var1, String var2, Writer var3) throws ParseException;
    }
}

