/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.semarglproject.rdf.NQuadsSerializer;
import org.semarglproject.rdf.NTriplesParser;
import org.semarglproject.rdf.NTriplesSerializer;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.rdf.TurtleSerializer;
import org.semarglproject.sink.CharOutputSink;
import org.semarglproject.sink.CharSink;
import org.semarglproject.sink.DataSink;
import org.semarglproject.sink.TripleSink;
import org.semarglproject.source.StreamProcessor;
import org.semarglproject.test.SesameTestHelper;
import org.semarglproject.test.TestNGHelper;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public final class NTriplesParserTest {
    private static final String TEST_OUTPUT_DIR = "target/ntriples-output/";
    private static final String FETCH_NTRIPLES_TESTS_SPARQL = "fetch_ntriples_tests.sparql";
    private static final Map<String, String> LOCAL_MIRRORS = new HashMap<String, String>(){
        {
            this.put("http://www.w3.org/2000/10/rdf-tests/rdfcore/", "w3c/");
        }
    };
    private static final String TESTSUITE_MANIFEST_URI = "http://www.w3.org/2000/10/rdf-tests/rdfcore/Manifest.rdf";
    private CharOutputSink charOutputSink;
    private StreamProcessor streamProcessorTtl;
    private StreamProcessor streamProcessorNt;
    private StreamProcessor streamProcessorNq;
    private SesameTestHelper sth;

    @BeforeClass
    public void init() {
        this.sth = new SesameTestHelper(TEST_OUTPUT_DIR, LOCAL_MIRRORS);
        this.charOutputSink = new CharOutputSink("UTF-8");
        this.streamProcessorTtl = new StreamProcessor((DataSink)NTriplesParser.connect((TripleSink)TurtleSerializer.connect((CharSink)this.charOutputSink)));
        this.streamProcessorNt = new StreamProcessor((DataSink)NTriplesParser.connect((TripleSink)NTriplesSerializer.connect((CharSink)this.charOutputSink)));
        this.streamProcessorNq = new StreamProcessor((DataSink)NTriplesParser.connect((TripleSink)NQuadsSerializer.connect((CharSink)this.charOutputSink)));
    }

    @DataProvider
    public Object[][] getTestSuite() throws IOException {
        String queryStr = IOUtils.toString((InputStream)this.sth.openStreamForResource(FETCH_NTRIPLES_TESTS_SPARQL));
        List testCases = this.sth.getTestCases(TESTSUITE_MANIFEST_URI, queryStr, TestCase.class);
        return TestNGHelper.toArray((Collection)testCases);
    }

    @Test(dataProvider="getTestSuite")
    public void runWithTurtleSink(TestCase caseName) throws Exception {
        this.runTest(caseName, new TestCallback(this.charOutputSink, this.streamProcessorTtl, "ttl"));
    }

    @Test(dataProvider="getTestSuite")
    public void runWithNTriplesSink(TestCase caseName) throws Exception {
        this.runTest(caseName, new TestCallback(this.charOutputSink, this.streamProcessorNt, "nt"));
    }

    @Test(dataProvider="getTestSuite")
    public void runWithNQuadsSink(TestCase caseName) throws Exception {
        this.runTest(caseName, new TestCallback(this.charOutputSink, this.streamProcessorNq, "nq"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(TestCase testCase, SaveToFileCallback callback) {
        String resultFilePath = this.sth.getOutputPath(testCase.input, callback.getOutputFileExt());
        new File(resultFilePath).getParentFile().mkdirs();
        try {
            InputStreamReader input = new InputStreamReader(this.sth.openStreamForResource(testCase.input), "UTF-8");
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(resultFilePath), "UTF-8");
            try {
                callback.run(input, testCase.input, output);
            }
            finally {
                IOUtils.closeQuietly((Reader)input);
                IOUtils.closeQuietly((Writer)output);
            }
        }
        catch (ParseException e) {
            Assert.fail();
        }
        catch (IOException e) {
            Assert.fail();
        }
        Assert.assertTrue((boolean)this.sth.areModelsEqual(resultFilePath, testCase.result, testCase.input));
    }

    public static final class TestCase {
        public String name;
        public String input;
        public String result;

        public String toString() {
            return this.name;
        }
    }

    public static interface SaveToFileCallback {
        public void run(Reader var1, String var2, Writer var3) throws ParseException;

        public String getOutputFileExt();
    }

    private static class TestCallback
    implements SaveToFileCallback {
        private final CharOutputSink charOutputSink;
        private final StreamProcessor streamProcessor;
        private final String fileExt;

        private TestCallback(CharOutputSink charOutputSink, StreamProcessor streamProcessor, String fileExt) {
            this.charOutputSink = charOutputSink;
            this.streamProcessor = streamProcessor;
            this.fileExt = fileExt;
        }

        @Override
        public void run(Reader input, String inputUri, Writer output) throws ParseException {
            this.charOutputSink.connect(output);
            this.streamProcessor.process(input, inputUri);
        }

        @Override
        public String getOutputFileExt() {
            return this.fileExt;
        }
    }
}

